 <script>
     $(document).ready(function() {

        @if ($errors->has('edit_duplicate_asset_serial_no') || $errors->has('edit_duplicate_asset_asset_tag'))
        $("#editDuplicateAssetModal").modal({ show: true });
        @endif



        var table = $('.footable').DataTable({
            "processing": true,
            "serverSide": true,
            "ajax":{
                "url": "{{ route('duplicate-assets-data') }}",
                "dataType": "json",
                "type": "POST",
                "data": function( result ) {
                    result.form = $('#search-form').serializeObject();
                }
            },
            lengthMenu: [
                [10, 25, 50, 100],
            	[10, 25, 50, 100]
            ],
            iDisplayLength: 50,
            "columns": [
                { "data": "id" },
                { "data": "asset_tag" },
                { "data": "serial_no" },
                { "data": "asset_type" },
                { "data": "make_and_model" },
                { "data": "tech_specs" },
                { "data": "asset_status" },
                { "data": "user_location" },
                { "data": "last_seen" },
                { "data": "action" }
            ],
            'rowsGroup': [1],
            columnDefs: [
                { orderable: false, targets: '_all' }
            ],
            "aaSorting": [],
            "bAutoWidth": false,
            "bFilter": true,
            "searching": false,
            fixedHeader:true,
		    "scrollX": true,
		    fixedColumns: true,
		    fixedColumns: {
			    left: 3
		    },
            "createdRow": function( row, data, dataIndex ) {
              $(row).attr('data-id', data.dataId);
              $(row).attr('data-parent', data.dataParent);
              $(row).addClass(data.dataLast ? 'last' : '');
			},

            "fnDrawCallback": function (oSettings) {
                // table.responsive.rebuild();
                // table.responsive.recalc();
                table.columns.adjust();
                if (table.page.info().recordsTotal == 0) {
                    $("#export-csv").hide();
                } else {
                    $("#export-csv").show();
                }
            },


        });

        // Data table column toggle
        $(document).on('click', 'span.col-toggle', function (e) {
            e.preventDefault();
            $(this).toggleClass('col-hidden');
            // Get the column API object
            var column = table.column($(this).attr('data-column'));

            // Toggle the visibility
            column.visible(!column.visible());
        });

        $('#deleteduplicateAssetModal').on('show.bs.modal', function (e) {
            var id = $(e.relatedTarget).data('id');
            $('#delete-asset-id').val(id);
        });


        $('#search-form').submit(function (e) {
            e.preventDefault();
            table.draw();
        });

        $('#export-csv').on('click', function(e) {
            e.preventDefault();
            $('.export-ajax-loader').show();
            $("#export-csv").hide();
            $.ajax({
                type: "POST",
                url: "{{route('export-duplicated-asset')}}",
                data: $('#search-form').serializeObject(),
                dataType: 'text',
                success: function(result) {
                    if (result == 'background_download') {
						location.reload();
					}else{
                        var blob = new Blob([result]);
                        if (window.navigator.msSaveOrOpenBlob)
                            window.navigator.msSaveBlob(blob, "assets-duplication.csv");
                        else
                        {
                            var a = window.document.createElement("a");
                            a.href = window.URL.createObjectURL(blob, {type: "text/plain"});
                            a.download = "assets-duplication.csv";
                            document.body.appendChild(a);
                            a.click();
                            document.body.removeChild(a);
                        }
                    }
                    $('.export-ajax-loader').hide();
                    $("#export-csv").show();
                }
            })
        });

        $('#mergeduplicateAssetModal').on('show.bs.modal', function (e) {
            $('.merge-asset-options').empty();
            var id = $(e.relatedTarget).data('id');
            var childIds = $(e.relatedTarget).data('child_ids');
            $('.modal-ajax-loader').show();

            $.ajax({
                type: "POST",
                url: "{{route('get-asset-data-for-merge')}}",
                data:{
                    id : id,child_ids : childIds
                },
                success: function(result) {
                    let options = '';

                    // if (result.asset) {
                    //     options += '<option value="' + result.asset.id + '">' + result.asset.serial_no  + '</option>';
                    // }

                    if (result.duplicatedAssets) {
                        $.each(result.duplicatedAssets, function(key,val) {
                            if(val.asset_status_id == result.asset.asset_status_id){
                                options += '<option value="' + val.id + '">' + val.serial_no  + '</option>';
                            }
                        });
                    }
                    $('.merge-asset-options').append(options);
                    $('.merge-asset-options').trigger("chosen:updated");
                    $('.modal-ajax-loader').hide();
                }
            })
        });

        $("#merge-assets-submit").on('click', function () {
            $(".merge-validation-msg").hide();

            if ($("#primary_asset").val() == $("#asset_to_delete").val()) {
                $(".merge-validation-msg").show();

                return false;
            }

            $("#merge-duplicate-assets-form").submit();
        })

        $('#confirm-delete').on('show.bs.modal', function (e) {
            var url = $(e.relatedTarget).data('url');
            $('#purge-form').attr('action',url);
            $('#confirm-message').html('Are you sure you want to delete this asset?');
        });

        $(".delete-duplicate-asset-button").on("click",function() {
            $('#purge-form').submit();
        });

        $('#editDuplicateAssetModal').on('show.bs.modal', function (e) {
            var id = $(e.relatedTarget).data('id');
            var serial = $(e.relatedTarget).data('serial');
            var tag = $(e.relatedTarget).data('tag');

            $("#editDuplicateAssetId").val(id);
            $("#editDuplicateAssetSerialNo").val(serial);
            $("#editDuplicateAssetTag").val(tag);
        });

        $("#updateAssetsSubmit").click(function(){
            $("#updateDuplicateAssetsForm").submit();
        })

        $('#mergeduplicateAssetModal').on('shown.bs.modal', function () {
            $(".merge-validation-msg").hide();
        });

    });
</script>
<style>
    .last td
    {
        border-bottom: 2px solid black;
    }
    .dataTables_paginate {
        margin-top: 20px!important;
    }
</style>