@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'Duplicate Assets', 'parentUrl' => '/report', 'parentTitle' => 'Reports'])

<div class="wrapper-content">

    <div class="container-fluid">

       @include('reports.duplicate-assets.partials.filter')

       <div class="row">

        <div class="col-lg-12">

            <div class="ibox">

                <div class="ibox-content">
                    @include('partials.success')
                    @include('partials.error-message')
                    <div class="ibox-tools">

                        <a href="#" id="export-csv" class="btn btn-primary">Export to CSV</a>
                    </div>

						<div class="export-ajax-loader" align="center" style="display:none"><img src="/img/ajax-loader-full-width.gif" height="25" width="25"></div>
                        <div class="dt-coltoggler-wrapper ">
                            <p>Click to toggle table columns: </p>
                        </div>


                    <table class="footable table table-stripped table-hover nowrap three-col-fixed has-column-toggler" data-page-size="1" data-filter=#filter>

                        <thead>

                            <tr>

                                <th>#</th>

                                <th>Asset Tag #</th>

                                <th>Serial #</th>

                                <th>Asset Type</th>

                                <th>Hardware Standard</th>

                                <th>Technical Specs</th>

                                <th>Asset Status</th>

                                <th>User/Location</th>

                                <th>Last Seen</th>

                                <th>Action</th>

                            </tr>

                        </thead>

                        <tbody>

                        </tbody>


                    </table>

                </div>

            </div>

        </div>

    </div>

</div>
@include('reports.duplicate-assets.partials.merge-asset')
@include('reports.duplicate-assets.partials.edit-duplicate-asset-modal')
@include('reports.duplicate-assets.partials.confirm-delete')
@stop

@section('help-links')
@include('help.help-links',['helpLink'=>config('help-links.help_links.asset_reports'),'helpTitle'=>config('help-links.help_titles.asset_reports')])
@endsection

@section('after_scripts')
@include('reports.scripts.common')
@include('reports.duplicate-assets.scripts.script')
@include('reports.scripts.datatable-column-toggle-script');
@stop