<style>
#assets .dataTables_scrollHead {
	top: 0!important;
}
</style>

<script>
var graphLabel;
var pageTheme = window.themeType;

// Define a property with a setter function for window.themeType
Object.defineProperty(window, 'themeType',{
	set: function(newValue) {
		pageTheme = newValue;
		$("#form-depreciation-report").submit();
	}
});

var lineOptions = {
		responsive: true,
		legend: {
		display: false,
	},
	tooltips: {
		callbacks: {
			label: function(tooltipItems, data) {
				return "$" + tooltipItems.yLabel.toString();
			}
		}
	},
	title:{
		display:true,
		position:'bottom',
		text:'Age in year'
	},
	scales: {
		yAxes: [ {
		display: true,
		scaleLabel: {
			display: true,
			labelString: 'Value in USD($)'

		},
		ticks: { min: 0},
		} ]
	},
	elements: {
		line: {
			tension: 0
		}
	}
};

$(function () {
	$("#form-depreciation-report select").on('change', function(){
        $('#form-depreciation-report').submit();
    });

	$.fn.serializeObject = function(){
		var obj = {};

		$.each( this.serializeArray(), function(i,o){
			var n = o.name, v = o.value;

			obj[n] = obj[n] === undefined ? v
				: $.isArray( obj[n] ) ? obj[n].concat( v )
				: [ obj[n], v ];
		});

		return obj;
	};
});

function loadData()
{
	$("#data_list").show();
	window.table = $('.footable').DataTable({
		responsive: false,
		processing: true,
		serverSide: true,
		info: true,
		bAutoWidth: false,
		fixedHeader:true,
		scrollX: true,
		fixedColumns: true,
		fixedColumns: {
			left: 3
		},
		ajax:{
			"url": "{{ route('depreciation-value-data') }}",
			"dataType": "json",
			"type": "POST",
			"data": function( result ) {
				result.form = $('#form-depreciation-report').serializeObject();
			}
		},
		columns: [
			{ "data": "id"},
			{ "data": "asset_tag" },
			{ "data": "serial_no" },
			{ "data": "hardware_standard" },
			{ "data": "technical_spec" },
			{ "data": "asset_status" },
			{ "data": "user_location" },
			{ "data": "original_value" },
			{ "data": "depreciated_value" },
			{ "data": "age" },
		],
		lengthMenu: [
			[10, 25, 50, 100],
			[10, 25, 50, 100]
		],
		iDisplayLength: 50,
		fnDrawCallback: function(oSettings) {
			if (oSettings._iRecordsDisplay == 0) {
				$("#export-csv").hide();
			} else {
				$("#export-csv").show();
			}
		}
	});
}

$(document).ready(function () {
	// Data table column toggle
	$('span.col-toggle').on('click', function (e) {
		e.preventDefault();
		$(this).toggleClass('col-hidden');
		// Get the column API object
		var column = window.table.column($(this).attr('data-column'));
		// Toggle the visibility
		column.visible(!column.visible());
	});

	$("#form-depreciation-report").on('submit', function(e) {
		e.preventDefault();

		if (window.table == undefined) {
			loadData();
		} else {
			window.table.draw();
		}

		$.ajax({
			url: $(this).attr('action'),
			method: $(this).attr('method'),
			data: $(this).serializeObject(),
			dataType: "JSON",
			success: function (response) {
				$('#depreciation-report-chart').html("");

				if (Object.keys(response.graphArray).length > 0) {
					$("#data_list").show();
					$('#depreciation-report-chart').html(response.chartHtml);

					Object.keys(response.graphArray).forEach(function(key){
						var graph = response.graphArray[key];
						var variable = {
							labels: response.yearsLabel,
							datasets: [
								{
									label: key,
									backgroundColor: pageTheme == 'dark' ? "{{ config('graph-settings.backgroundColorDark') }}" : "{{ config('graph-settings.backgroundColor') }}",
									borderColor: pageTheme == 'dark' ? "{{ config('graph-settings.borderColorDark') }}" : "{{ config('graph-settings.borderColor') }}",
									pointBackgroundColor: pageTheme == 'dark' ? "{{ config('graph-settings.pointBackgroundColorDark') }}" : "{{ config('graph-settings.pointBackgroundColor') }}",
									pointBorderColor: pageTheme == 'dark' ? "{{ config('graph-settings.pointBorderColorDark') }}" : "{{ config('graph-settings.pointBorderColorDark') }}",
									data: graph[1]
								}
							]
						};
						var ctx = document.getElementById("lineChart_" + graph[0]).getContext("2d");
						new Chart(ctx, {type: 'line', data: variable, options:lineOptions});
					});
				} else {
					$("#data_list").hide();
				}
			}
		})
	});

	// cutton click of singlke export for grap and report
	$(document).on('click', '#save-chart-and-list', function (e) {
		e.preventDefault();
		var click = $(this);
		var canvas = $("#depreciation-report-chart").find('canvas')[0];

		canvas.toBlob(function(blob) {
			var heading = click.attr('data-name');
			var slug = click.attr('data-slug');
			fd = new FormData();
			fd.append('image', blob);
			fd.append('name', slug);
			$.ajax({
				type: "POST",
				url: "/save-image",
				data: fd,
				processData: false,
				contentType: false,
				success: function(result) {
				var name = click.attr('data-name');
				var filename = click.attr('data-filename');

        		if (!result || result.error) {
                $('#sync-error').show();
                $('#sync-error-msg').text(result.error);
                return;
            }
				
				    exportReport(name, filename, result.path);
			  },
        error: function(xhr, status, error) {
            $('#sync-error').show();
            $('#sync-error-msg').text(
                "Error: Failed to export chart. Please try again.");
        }
			})
		});
	})

	function exportReport(name, filename, image)
	{
      var form = $("#form-depreciation-report").serializeObject();
	  form.name = name;
	  form.filename = filename;
	  form.image = image;

      $('.ajax-loader').show();
      $.ajax({
        type: "POST",
        url: "{{ route('depreciation-value-graph-export-with-data') }}",
        data: form,
		xhrFields:{
            responseType: 'blob'
        },
        success: function (result) {
          var blob = new Blob([result]);
          if (window.navigator.msSaveOrOpenBlob)  // IE hack; see http://msdn.microsoft.com/en-us/library/ie/hh779016.aspx
            window.navigator.msSaveBlob(blob, filename + ".xlsx");
          else {
            var a = window.document.createElement("a");
            a.href = window.URL.createObjectURL(blob, { type: "text/plain" });
            a.download = filename + ".xlsx";
            document.body.appendChild(a);
            a.click();  // IE: "Access is denied"; see: https://connect.microsoft.com/IE/feedback/details/797361/ie-10-treats-blob-url-as-cross-origin-and-denies-access
            document.body.removeChild(a);
          }
          $('.ajax-loader').hide();
        }
      })
	}
});

</script>
