<div class="ibox">
    <div class="ibox-title">
        <div class="ibox-tools">
            <h5>Filters</h5>
            <a data-toggle="collapse" href="#collapseFilter" class="collapse-link"><i class="icon icon-e-delete"></i></a>
        </div>
    </div>
    <div class="collapse in" id="collapseFilter" aria-expanded="true">
        <div class="ibox-content">
            <form action="{{ route('depreciation-value-search') }}" method="post" name="form-depreciation-report" id="form-depreciation-report">
                {{csrf_field()}}
                <div class="row">
                    <div class="col-md-3">
                        <div class="form-group">
                            <label class="control-label">Asset Type </label>
                            <select class="select2" id="asset_type" name="asset_type" data-placeholder="Select">
                                <option value="">Select</option>
                                @foreach($assetTypes as $assetType)
                                <option value="{{$assetType->id}}">{{$assetType->name}}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label class="control-label">Manufacturer</label>
                            <select class="form-control select2" multiple name="manufacturer" id="manufacturer" data-placeholder="Select">
                            @foreach(\App\Models\Manufacturer::orderBy('name')->get() as $manufacturer)
                                <option value="{{$manufacturer->id}}">{{$manufacturer->name}}</option>
                            @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label class="control-label">Hardware Standard</label>
                            <select class="select2" id="make_and_model" name="make_and_model" data-placeholder="Select" multiple>
                                @foreach($hardWareStandards as $hardware)
                                <option value="{{$hardware->id}}">{{$hardware->manufacturer}} - {{$hardware->makeAndModel}}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label class="control-label">Technical Specs</label>
                            <select class="select2" id="technical_spec" name="technical_spec" data-placeholder="Select" multiple>
                                @foreach($techSpecs as $technicalSpec)
                                <option value="{{$technicalSpec->id}}">{{ $technicalSpec->details }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>