<style>
#assets .dataTables_scrollHead {
	top: 0!important;
}
</style>
<script>
	var graphLabel;
	var pageTheme = window.themeType;

	// Define a property with a setter function for window.themeType
	Object.defineProperty(window, 'themeType',{
		set: function(newValue) {
			pageTheme = newValue;
			$("#damaged-trends-search-form").submit();
		}
	});
	$(document).ready(function() {

		$.fn.serializeObjectCustom = function(){
          var obj = {};

          $.each( this.serializeArray(), function(i,o){
            var n = o.name.replace('[]', ''), v = o.value;

            obj[n] = obj[n] === undefined ? v
                : $.isArray( obj[n] ) ? obj[n].concat( v )
                : [ obj[n], v ];
          });

          return obj;
      };

		var table = $('.footable').DataTable({
			"processing": true,
			"serverSide": true,
			"ajax":{
				headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')},
				"url": "{{ route('damaged-trends-report-data') }}",
				"dataType": "json",
				"type": "POST",
				"data": function( result ) {
					result.form = $('#damaged-trends-search-form').serializeObjectCustom();
				}
			},
			"columns": [
				{ "data": "id" },
				{ "data": "asset_tag" },
				{ "data": "serial_no" },
				{ "data": 'asset_type' },
				{ "data": "asset_status" },
				{ "data": "hardware_standard" },
				{ "data": "technical_specs" },
				{ "data": "user_location" },
				{ "data": "damaged_at" },
			],
			lengthMenu: [
				[10, 25, 50, 100],
            	[10, 25, 50, 100]
			],
			iDisplayLength: 50,
			columnDefs: [
				{ orderable: false, targets: '_all' }
			],
			"aaSorting": [],
			"fnDrawCallback": function( settings ) {
				if (table.page.info().recordsTotal == 0) {
					$("#save-chart-and-list").hide();
				} else {
					$("#save-chart-and-list").show();
				}
        	},
			"bAutoWidth": false,
			"bFilter": true,
			"searching": false,
			scrollX: true,
			fixedHeader:true,
			fixedColumns: true,
			fixedColumns: {
				left: 3
			},
    	});

		// Data table column toggle
		$(document).on('click', 'span.col-toggle', function (e) {
			e.preventDefault();
			$(this).toggleClass('col-hidden');
			// Get the column API object
			var column = table.column($(this).attr('data-column'));

			// Toggle the visibility
			column.visible(!column.visible());
		});


		// export report data
		function exportReport(name, filename, image)
		{
			var form = $("#damaged-trends-search-form").serializeObjectCustom();
			form.name = name;
			form.filename = filename;
			form.image = image;

			$('.ajax-loader').show();
			$.ajax({
				type: "POST",
				url: "{{ route('damaged-trends-export') }}",
				data: form,
				xhrFields:{
					responseType: 'blob'
				},
				success: function (result) {
					var blob = new Blob([result]);
					if (window.navigator.msSaveOrOpenBlob)  // IE hack; see http://msdn.microsoft.com/en-us/library/ie/hh779016.aspx
					window.navigator.msSaveBlob(blob, filename + ".xlsx");
					else {
					var a = window.document.createElement("a");
					a.href = window.URL.createObjectURL(blob, { type: "text/plain" });
					a.download = filename + ".xlsx";
					document.body.appendChild(a);
					a.click();  // IE: "Access is denied"; see: https://connect.microsoft.com/IE/feedback/details/797361/ie-10-treats-blob-url-as-cross-origin-and-denies-access
					document.body.removeChild(a);
					}
					$('.ajax-loader').hide();
				}
			})
		}

		// cutton click of singlke export for grap and report
		$(document).on('click', '#save-chart-and-list', function (e) {
			e.preventDefault();
			var click = $(this);
			var canvasArea = $(this).data('canvas');
			var canvas = document.getElementById(canvasArea);

			canvas.toBlob(function(blob) {
				var heading = click.attr('data-name');
				var slug = click.attr('data-slug');
				fd = new FormData();
				fd.append('image', blob);
				fd.append('name', slug);
				$.ajax({
					type: "POST",
					url: "/save-image",
					data: fd,
					processData: false,
					contentType: false,
					success: function(result) {
				var name = click.attr('data-name');
				var filename = click.attr('data-filename');

        		if (!result || result.error) {
                $('#sync-error').show();
                $('#sync-error-msg').text(result.error);
                return;
            }
				
				    exportReport(name, filename, result.path);
			  },
        error: function(xhr, status, error) {
            $('#sync-error').show();
            $('#sync-error-msg').text(
                "Error: Failed to export chart. Please try again.");
        }
				})
			});
		});
	});

	$(function () {

		var reportTypeonPageLoad = $('#report_type').val();
		setAttributeDropdownWithReportType(reportTypeonPageLoad);

		$('.chosen-select').chosen({width: "100%"});

		$('.select2').select2();

		$('#report_type').on('change', function(e) {
			let reportType = $(this).val();
			setAttributeDropdownWithReportType(reportType);

		});

		function setAttributeDropdownWithReportType(reportType)
		{
			if(reportType == 'asset_type') {
				$('#asset_div').show();
				$('#location_div').hide();
				$('#department_div').hide();
			}
			if(reportType == 'location') {
				$('#location_div').show();
				// $('#asset_div').hide();
				$('#department_div').hide();
			}
			if(reportType == 'department') {
				$('#department_div').show();
				$('#location_div').hide();
				// $('#asset_div').hide();
			}
		}


		var barData = {
		@if(isset($monthNames))
			labels: {!! json_encode($monthNames) !!},
			datasets: [
				@foreach($selectedMakeAndModels as $model)
				{
					label: "{{$model->makeModelName}}",
					backgroundColor: pageTheme == 'dark' ? "{{ config('graph-settings.backgroundColorDark') }}" : "{{ config('graph-settings.backgroundColor') }}",
					pointBorderColor: pageTheme == 'dark' ? "{{ config('graph-settings.pointBorderColorDark') }}" : "{{ config('graph-settings.pointBorderColorDark') }}",
					data: {!! json_encode($datas[$model->makeModelName]) !!},
				},
				@endforeach
			]
		@endif
		};

		var barOptions = {
			responsive: true,
			legend: {
		        position: 'right'
		    },
		    scales: {
		        yAxes: [{
		            ticks: {
		                beginAtZero:true,
		                userCallback: function(label, index, labels) {
							if (Math.floor(label) === label) {
								return label;
							}
                 		}
		            }
		        }],
				xAxes: [{
					barPercentage: {!! config('graph-settings.barPercentage') !!},
				}]
		    }

		};

		var canvas = document.getElementById("barChart");

		if (canvas != null) {
			ctx2 = canvas.getContext("2d");
			let newChart = new Chart(ctx2, {type: 'bar', data: barData, options:barOptions});
			canvas.onclick = function(evt) {
				let activePoints = newChart.getElementsAtEvent(evt);
				if (activePoints[0]) {
					let chartData = activePoints[0]['_chart'].config.data;
					let idx = activePoints[0]['_index'];
					graphLabel = chartData.labels[idx];
					$('#assets').modal('show');

					console.log(window.popUpTable);

					if (window.popUpTable == undefined) {
						loadAssetsInPopUp();
					} else {
						window.popUpTable.draw();
					}
				}
			};
		}

		$('#dept-type').on('change', function () {
            if (this.value === 'custom'){
                $("#custom-date").show();
            } else {
                $("#custom-date").hide();
            }
        });

        $('#data_1 .input-group.date').datepicker({
			todayBtn:"linked",
			clearBtn:true,
			keyboardNavigation: false,
			forceParse: false,
			calendarWeeks: false,
			autoclose: true
		});

		//show assets of the selected bar in the pop up
		function loadAssetsInPopUp()
		{
			window.popUpTable = $('.assets-pop-list').DataTable({
				responsive: false,
				processing: true,
				serverSide: true,
				info: true,
				bAutoWidth: false,
				fixedHeader:true,
				scrollX: true,
				ordering: false, // Disable sorting
				searching: false, // Disable searching
				ajax:{
					"url": "{{ route('damaged-trends-report-data') }}",
					"dataType": "json",
					"type": "POST",
					"data": function( result ) {
						result.form = $('#damaged-trends-search-form').serializeObjectCustom();
						result.form.month = graphLabel;
					}
				},
				columns: [
					{ "data": "id" },
					{ "data": "asset_tag" },
					{ "data": "serial_no" },
					{ "data": "asset_status" },
					{ "data": "hardware_standard" },
					{ "data": "technical_specs" },
					{ "data": "user_location" },
				],
				lengthMenu: [
					[ 50, 100, 200],
					[ '50', '100', '200']
				],
				iDisplayLength: 50,
				fnDrawCallback: function(oSettings) {}
			});
		}


	});



</script>
