@if(isset($assetList))

<div class="col-lg-12">

<div class="ibox">

    <div class="ibox-title">
        <div class="ibox-tools">
            <a href="#" id="export-csv" class="btn btn-primary">Export to CSV</a>
        </div>
    </div>

    <div class="ibox-content">

        @include('partials.success')

        <div class="ajax-loader"><img src="/img/ajax-loader-full-width.gif"></div>

        <div id="saved-search-success"></div>

        <div class="dt-coltoggler-wrapper ">
            <p>Click to toggle table columns: </p>
        </div>

        <div class="table-responsive">
        
        <table class="table table-stripped table-hover" data-page-size="25" id="damagedTrendsTable">
            <thead>

                <tr>

                    <th>#</th>

                    <th>Asset Tag #</th>

                    <th>Serial #</th>

                    <th>Status</th>

                    <th>Hardware Standard</th>

                    <th>Tech Specs</th>

                    <th>User/Location</th>

                    <th>Damaged Date</th>

                </tr>

            </thead>

            <tbody>
            @if(isset($assetList))
                                            @foreach($assetList as $assetHistory)
                                            <tr>

                                                <td>{{$loop->iteration}}</td>
                                                <td><a
                                                        href="{{route('assets.show', ['asset' => $assetHistory->asset->id])}}">{{$assetHistory->asset->asset_tag
                                                        ?? ''}}</a></td>
                                                <td><a
                                                        href="{{route('assets.show', ['asset' => $assetHistory->asset->id])}}">{{$assetHistory->asset->serial_no
                                                        ?? ''}}</a></td>
                                                <td>{{$assetHistory->asset->assetStatus->name ?? ''}}</td>
                                                <td>{{$assetHistory->asset->makeAndModel->makeModelName ?? ''}}</td>
                                                <td>{{$assetHistory->asset->technicalSpec->details ?? ''}}</td>
                                                <td>{{$assetHistory->asset->user ?
                                                    ($assetHistory->asset->user->userName) :
                                                    ($assetHistory->asset->location ?
                                                    $assetHistory->asset->location->room_name : '')}}</td>
                                                <td>{{$assetHistory->CreatedDateLabel ?? ''}}</td>
                                            </tr>
                                            @endforeach
                                            @endif

                                           

                                        </tbody>

        </table>


        </div>

        </div>

</div>

</div>

@endif