<div class="col-lg-12">
    <div class="ibox">
        <div class="ibox-title">
            <div class="ibox-tools">
                <h5>Filters</h5>
                <a data-toggle="collapse" href="#collapseFilter" class="collapse-link"><i class="icon icon-e-add"></i></a>
            </div>
        </div>
        <div class="ibox-content">
            @include('partials.error')
            @include('partials.success')
            @include('partials.error-message')
            <form method="post" action="" id="damaged-trends-search-form">
                {{csrf_field()}}
                <div class="row">
                    <div class="col-md-3 divHeight">
                        <div class="form-group">
                            <label class="control-label">Report Type {{ ucwords(str_replace("_", " ", $selectedData['type'] ?? '')) }}</label>
                            <select class="select2 form-control" id="report_type" name="report_type">
                                <option value="asset_type"
                                ($selectedData['type']=='asset_type' ? 'selected' : '' ) : '' }}
                                {{ old('report_type') == 'asset_type' ? 'selected' : '' }}
                                >Asset Type</option>
                                <option value="location" {{$selectedData ?
                                    ($selectedData['type']=='location' ? 'selected' : '' ) : '' }}
                                    {{ old('report_type') == 'location' ? 'selected' : '' }}
                                    >
                                    Location</option>
                                <option value="department" {{$selectedData ?
                                    ($selectedData['type']=='department' ? 'selected' : '' ) : '' }}
                                    {{ old('report_type') == 'department' ? 'selected' : '' }}
                                    >
                                    Department</option>
                            </select>
                        </div>
                    </div>

                    <div class="col-md-3 divHeight"  id="location_div" {{$selectedData ? ($selectedData['type'] !='location' ? "style=display:none" : '' ) : "style=display:none" }}>
                        <div class="form-group">
                            <label class="control-label">Locations</label>
                            <select class="chosen-select form-control" multiple id="location" name="location[]" data-placeholder="Select">
                                @foreach($filterDataOptions['locations'] as $location)
                                    <option value="{{$location->id}}"
                                    {{$selectedData ?
                                    ($selectedData['location'] ? (in_array($location->id,
                                    $selectedData['location']) ? 'selected': '') : '') :
                                    ''}}
                                    {{ old('location') ? (in_array($location->id, old('location')) ? 'selected' : '') : '' }}
                                    >{{$location->room_name}}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>

                    <div class="col-md-3 divHeight"  id="department_div" {{$selectedData ? ($selectedData['type'] !='department' ? "style=display:none" : '' ) : "style=display:none" }}>
                        <div class="form-group">
                            <label class="control-label">Departments</label>
                            <select class="chosen-select form-control" multiple id="department" name="department[]" data-placeholder="Select">
                                @foreach($filterDataOptions['departments'] as $department)
                                    <option value="{{ $department->id }}"
                                        {{ ($selectedData && isset($selectedData['department']) && in_array($department->id, $selectedData['department'])) ||
                                            old('department') && in_array($department->id, old('department')) ? 'selected' : '' }}
                                        {{ old('department') ? (in_array($department->id, old('department')) ? 'selected' : '') : '' }}
                                        >
                                        {{ $department->name }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                    </div>

                    <div class="col-md-3 divHeight"  id="asset_div">
                        <div class="form-group">
                            <label class="control-label">Asset Type</label>
                            <select class="chosen-select form-control" multiple id="asset_type" name="asset_type[]" data-placeholder="Select">
                                @foreach($filterDataOptions['assetTypes'] as $assetType)
                                    <option value="{{$assetType->id}}"
                                    {{$selectedData ?
                                    ($selectedData['asset_type'] ? (in_array($assetType->id,
                                    $selectedData['asset_type']) ? 'selected': '') : '') :
                                    ''}}
                                    {{ old('asset_type') ? (in_array($assetType->id, old('asset_type')) ? 'selected' : '') : '' }}
                                    >{{$assetType->name}}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="col-md-3 divHeight">
                        <div class="form-group">
                            <label class="control-label">Manufacturer</label>
                            <select class="form-control select2 filter" multiple name="manufacturer[]" id="manufacturer" data-placeholder="Select">
                            @foreach(\App\Models\Manufacturer::orderBy('name')->get() as $manufacturer)
                                <option value="{{$manufacturer->id}}"
                                    {{ ($selectedData && isset($selectedData['manufacturer']) && in_array($manufacturer->id, $selectedData['manufacturer'])) ||
                                        (old('manufacturer') && in_array($manufacturer->id, old('manufacturer'))) ? 'selected' : '' }}
                                >{{$manufacturer->name}}</option>
                            @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="col-md-3 divHeight">
                        <div class="form-group">
                            <label class="control-label">Hardware Standard</label>
                            <select class="select2 form-control"  multiple id="make_and_model" name="make_and_model[]" data-placeholder="Select">
                                @foreach($filterDataOptions['makeAndModels'] as $makeAndModel)
                                    <option value="{{ $makeAndModel->id }}"
                                        {{ ($selectedData && isset($selectedData['make_model']) && in_array($makeAndModel->id, $selectedData['make_model'])) ||
                                            old('make_model') && in_array($makeAndModel->id, old('make_model')) ? 'selected' : '' }}
                                        {{ old('make_and_model') ? (in_array($makeAndModel->id, old('make_and_model')) ? 'selected' : '') : '' }}
                                        >
                                        {{ $makeAndModel->name }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                    </div>

                    <div class="col-md-3 divHeight">
                        <div class="form-group">
                            <label class="control-label">Date</label>
                            <select class="form-control select2" name="date-range" id="dept-type">
                                @foreach(['lifetime', 'last-30-days', 'last-60-days', 'this-month', 'last-month', 'this-quarter', 'custom'] as $option)
                                    <option value="{{ $option }}"
                                    {{ ($selectedData && $selectedData['date'] == $option) || old('date-range') == $option ? 'selected' : '' }}
                                    {{ old('date-range') && old('date-range') == $option ? 'selected' : ''}}
                                    >
                                        {{ ucfirst(str_replace('-', ' ', $option)) }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="col-md-3" id="custom-date" {{ (($selectedData && $selectedData['date'] == 'custom') || old('date-range') == 'custom') ? 'style=display:block' : 'style=display:none' }}>
                        <div class="form-group">
                            <label>Date Range</label>
                            <div class="form-group">
                                <div class="input-group date">
                                    <span class="input-group-addon"><i class="icon icon-calendar-2"></i></span>
                                    <input type="text" name="from-date" class="form-control readonly-white" placeholder="From" value="{{ ($selectedData && $selectedData['from-date']) ? $selectedData['from-date'] : (old('from-date') ? old('from-date') : '') }}" readonly="">
                                </div>
                            </div>

                            <div class="form-group">
                                <div class="input-group date">
                                    <span class="input-group-addon"><i class="icon icon-calendar-2"></i></span>
                                    <input type="text" name="to-date" class="form-control readonly-white" placeholder="To" value="{{ ($selectedData && $selectedData['to-date']) ? $selectedData['to-date'] : (old('to-date') ? old('to-date') : '')}}"  readonly>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-3">
                        <button type="submit" name="export-to-excel" class="btn btn-primary">Generate</button>
                    </div>

                </div>
        </form>
    </div>
</div>
</div>