<script src="/js/sweetalert2.all.min.js"></script>
<script>
    $(document).ready(function() {
        $('[data-toggle="tooltip"]').tooltip();
        formmodified = 0;
        $('form *').change(function() {
            formmodified = 0;
        });

        selectedLocation = "{{ isset($selectedLocationId) ? $selectedLocationId : '' }}";
        if (selectedLocation) {
            // Set the selected value using Select2
            $("#varience-create-form #location_id").val(selectedLocation).trigger('change');
        }
    });

    // Retives the locations freeze status
    $('#location_id').on('change', function() {
        var locationId = $(this).val();
        $.ajax({
            type: "POST",
            url: "/inventory-control/get-location-status",
            data: {
                locationId: locationId
            },
            success: function(result) {
                if (result == 0) {
                    $('#freeze').show();
                    $('#freeze-info').show();
                    $('#unfreeze').hide();
                }
                if (result == 1) {
                    $('#freeze').hide();
                    $('#freeze-info').hide();
                    $('#unfreeze').show();
                }
            }
        });
    });

    // Toggles free status of the location
    $(".freeze-unfreeze").click(function(e) {
        e.preventDefault();
        var id = $(this).attr('data-id');
        var locationName = $("#location_id option:selected").text();
        var locationId= $('#location_id').val();

        $.ajax({
            type: "POST",
            url: "/inventory-control/freeze-unfreeze-location",
            data: {
                id: id,
                locationId: locationId
            },
            success: function(result) {
                if (result.is_freeze == 0) {
                    // locationName = locationName.replace(' (Room is frozen for cycle count)', '');
                    $('#freeze').show();
                    $('#freeze-info').show();
                    $('#unfreeze').hide();
                    // $('#varience-create-form #location_id option[value='+locationId+']').prop('disabled', false);
                    // $('#varience-create-form #location_id option[value='+locationId+']').text(locationName);
                }
                else if (result.is_freeze == 1) {
                    // locationName += ' (Room is frozen for cycle count)';
                    $('#freeze').hide();
                    $('#freeze-info').hide();
                    $('#unfreeze').show();  
                    // $('#varience-create-form #location_id option[value='+locationId+']').prop('disabled', true);
                    // $('#varience-create-form #location_id option[value='+locationId+']').text(locationName);
                }
                $("#varience-create-form #location_id").select2("destroy");
                $("#varience-create-form #location_id").select2();
                $("#frozen-locations tbody").html(result.view);
            }
        });
    });

    $(document).on("click", ".unfreeze", function(e) {
        e.preventDefault();
        var locationId = $(this).attr('data-id');
        $('#confirm-unfreeze').modal('show');
        $('#confirm-unfreeze').attr('data-form', $(this).parent('form').attr('id'));
        $('#confirm-message').html('Are you sure you want to unfreeze this location ? ');

    });

    $(".unfreeze-button").on("click", function(e) {
        e.preventDefault();
        var formId= $('#confirm-unfreeze').attr('data-form');
        var formData = $("#" + formId).serialize();
        $.ajax({
            type: "POST",
            url: "/inventory-control/freeze-unfreeze-location",
            data: formData,
            success: function(result) {

                location.reload();
            }
        });
    });

    // On the loaction change brings the current scanned assets which are not merged
    $('#location_id').on('change', function() {
        @if (request()->path() == 'inventory-control/cycle-count' || request()->route()->getName() == 'cycle-count.merge')
            var locationId = $(this).val();
            var assetTypeId = $('#asset_type_id').val();
            if(assetTypeId == ''){
                assetTypeId = 0;
            }
            $('#submit_add').attr('disabled',true);
            $('#merge-button').attr('href', "/inventory-control/cycle-count/merge/"+locationId+"/"+assetTypeId);
            $.ajax({
                type: "POST",
                url: "/inventory-control/cycle-count.scanned-assets",
                data: { location_id : locationId },
                success: function(result) {
                    $('#asset-table tbody').html(result.view);
                    $('#count_add').val(result.count);
                    $('#submit_add').attr('disabled',false);
                }
            });
        @endif
    });

    // Disables all other asset types if the selected type is all elese reverse it, after assignes the href to merge button for selected asset type.
    $('#asset_type_id').on('change', function() {
        @if (request()->path() == 'inventory-control/cycle-count')
            var assetTypeId = $(this).val();
        
            if(jQuery.inArray("All",assetTypeId) != -1){
                    $('#asset_type_id').val("All");
                    $(this).children('option').not(':selected').each(function(){
                    $(this).attr('disabled','disabled');
                });
            } else {
                $(this).children('option').each(function(){
                    $(this).removeAttr('disabled');
                });
            }
        
            $('#asset_type_id').trigger('chosen:updated');
        
            if(assetTypeId == ''){
                assetTypeId = 0;
            }
            var locationId = $('#location_id').val();
            $('#merge-button').attr('href', "/inventory-control/cycle-count/merge/"+locationId+"/"+assetTypeId);
        @endif
    });

    /**
     * Remove the row from cycle count report on button click.
     * @param mixed id
     * 
     * @return [type]
     */
    function deleteVarianceRow(id,rowCount) {
        locationId = $("#location_id_added").val();
		assetTagId = $("#asset_tag_added" +rowCount).val();
        $.ajax({
            type: "POST",
            url: "/inventory-control/cycle-count-delete",
            data: {id: id, locationId: locationId, assetTagId: assetTagId},
            success: function(result) {
                $('#added-count-' + rowCount).empty();
            }
        });
    }

    // Checks the asset tag/ serial is already scanned.
    $('#asset_tag').on('change', function() {
        $('#errorText').html('');
        var asset = $(this).val();
        $('#asset-table').find('tr').each(function(i, el) {
            var tds = $(this).find('td.asset-tag-value');
            tableValue = tds.text();
            asset = asset.trim();
            var current = asset.toLowerCase();
            var existing = tableValue.toLowerCase();
            if (current == existing) {
                $('#errorText').html('Asset already scanned!');
                $('#asset_tag').val('');
            }
        });
    });

    // Confirm modal shows and on confirmations calls the merge function.
    $('#merge-button').on('click', function(e) {
        var $link = $(this);
        e.preventDefault();
        $('#confirm').modal({
                backdrop: 'static',
                keyboard: false
            })
            .on('click', '#confirm-merge-button', function(e) {
                window.location = $link.attr('href');
            });
        $("#cancel").on('click', function(e) {
            e.preventDefault();
            $('#confirm').modal.model('hide');
        });
    });

    // confirmation before merging without any assets
    @if (isset($mergedData) && $mergedData->isEmpty())
            $( "#assetsForm" ).submit(function( event ) {
            event.preventDefault(); // Prevent form submission by default

            Swal.fire({
                title: 'Are you sure you want to run the report without entering an asset?',
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: 'Yes',
                cancelButtonText: 'No'
            }).then((result) => {
                if (result.dismiss !== Swal.DismissReason.cancel) {
                // User confirmed, manually submit the form
                $("#assetsForm").off("submit").submit();
                }
            });
        });
    @endif
</script>
