<script src="/js/plugins/chosen/chosen.jquery.js"></script>
<script src="/js/plugins/dataTables/datatables.min.js"></script>
<script src="/js/plugins/chosen/chosen.ajaxaddition.jquery.js"></script>
<script src="/js/plugins/morris/raphael-2.1.0.min.js"></script>
<script src="/js/plugins/morris/morris.min.js"></script>
<link href="/css/plugins/dataTables/fixedHeader.dataTables.min.css" rel="stylesheet">

<script>

    $(document).ready(function() {
        $('.chosen-select').chosen({width: "100%"}).change(function() {
            $(this).closest('.form-group').next().find('input').focus();
        });
        
        $('.select2').select2();

        $('.select2-custom').select2({
            matcher: function(params, data) {
                return matchStart(params, data);
            },
        });

        $('.input-group.date').datepicker({
            clearBtn: true,
            autoclose: true,
        }).on('changeDate',function(e){
	        $('#search-form').submit();
	    });

        


        $.fn.serializeObject = function(){
           var obj = {};
            
           $.each( this.serializeArray(), function(i,o){
              var n = o.name, v = o.value;
                
              obj[n] = obj[n] === undefined ? v
                 : $.isArray( obj[n] ) ? obj[n].concat( v )
                 : [ obj[n], v ];
           });
            
           return obj;
        };

        var table = $('.footable').DataTable({

            "processing": true,
            "serverSide": true,
            "oLanguage": {
                "sEmptyTable": "No saved reports found"
            },
            "ajax":{
                "url": "{{ route('cycle-count.history.data') }}",
                "dataType": "json",
                "type": "POST",
                "data": function( result ) {
                    result.form = $('#search-form').serializeObject();
                }
            },
            "columns": [
                { "data": "id" },
                { "data": "room_name" },
                { "data": "date" },
                { "data": "asset_types" },
                { "data": "accuracy" },
            ],
            lengthMenu: [
                [ 50, 100, 200],
                [ '50', '100', '200']
            ],
            columnDefs: [
               { orderable: false, targets: [0,3] }
            ],
            "aaSorting": [],
            "dom": '<"top"i>rt<"bottom"flp><"clear">',
            "bAutoWidth": false,
            "bFilter": true,
            "bLengthChange": false,
            "searching": false,
            "responsive": true,
            "scrollCollapse": false,
            "scrollX": false,
            "scrollY": false,
            fixedHeader: {
				header: true,
			},
            fnDrawCallback: function (oSettings) {
                $("#variance-history-average").text(oSettings.json.average + "%");
                $("#variance-heighest-accuracy").text(oSettings.json.heighestAccuracy + "%");
                $("#variance-heighest-date").html(oSettings.json.heighestDate);
                $("#variance-lowest-accuracy").text(oSettings.json.lowestAccuracy + "%");
                $("#variance-lowest-date").text(oSettings.json.lowestDate);
                $("#morris-cycle-count-accuracy-chart").empty();
                $("#average-values-box").hide();
                $("#variance-graph-container").hide();

                if (oSettings.json.average != 0) {
                    $("#average-values-box").show();
                    $("#variance-graph-container").show();
                    Morris.Line({
                        element: 'morris-cycle-count-accuracy-chart',
                        data: oSettings.json.graphData,
                        xkey: 'date',
                        ykeys: ['accuracy'],
                        labels: ['Accuracy'],
                        parseTime: false,
                        xLabelAngle: 60,
                        smooth: false,
                        resize : true,
                    });
                }
            }
        });

        $('#search-form').submit(function (e) {
            e.preventDefault();
            table.draw();
        });

        $("#location_id").on('change', function(){
            $('#search-form').submit();
        });
         
    });

</script>