@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'Cycle Count', 'parentUrl' => '#', 'parentTitle' => 'Inventory Control'])
@include('reports.cycle-count.partials.cycle-count-submenu')


<div class="wrapper-content">

	<div class="container-fluid">

		@include('partials.error-message')

		<div class="row">

			<div class="col-lg-3">

				<div class="ibox">

					<div class="ibox-content">

						<form method="post" action="" id="varience-create-form">

							<input type="hidden" id="count_add" name="count_add" value="{{isset($mergedData) ? $mergedData->count() : 0}}">

							<div class="form-group">

								<label class="control-label">Step 1: Asset Location <span class="text-danger">*</span></label>

								@include('partials.dropdowns.location-all-warehouse', ['locationId' => $selectedLocationId??''])

							</div>

							<div class="form-group">

								<label class="control-label">Step 2: Asset Type <span class="text-danger">*</span></label>
								<select class="chosen-select" id="asset_type_id" multiple name="asset_type_id" data-placeholder="Select">
									<option value="All" {{isset($assetTypeIds) ? ( in_array('All', $assetTypeIds)  ? 'selected' : '') : ''}}>All Asset Types</option>
									@foreach($assetTypes as $type)      
									<option value="{{$type->id}}" {{isset($assetTypeIds) ? ( in_array($type->id, $assetTypeIds)  ? 'selected' : '') : (old('asset_type_id') == $type->id ? 'selected' : '')}}>{{$type->name}}</option>
									@endforeach
								</select>

							</div>

							<div class="form-group">

								<label class="control-label">Step 3: Scan Asset Tag # / Serial # <span class="text-danger">*</span></label>

								<input type="text" class="form-control" name="serial_no" id="serial_no">

								<span id="errorText" style="color:red"></span>

							</div>

							


							<div class="form-group text-right">

								<label class="control-label"></label>

								<input type="submit" class="btn btn-primary" value="Add" id="submit_add">
								<span style="float:left"> <span class="text-danger">*</span> Required</span>
							</div> 

						</form>

					</div>

				</div>

			</div>


			<div class="col-lg-9">

				<div class="ibox">

					<div class="ibox-content">

						@if(isset($mergedData))	
							<form method="post" id="assetsForm" action="{{route('cycle-count.generate')}}">

								{{csrf_field()}}
								<input type="hidden" name="asset_type_id" value="{{$assetTypeId}}">
								<input type="hidden" name="location_id" value="{{$locationId}}">

								<table class="table table-striped" id="asset-table">
									<thead>
										<tr>
											<th>#</th>
											<th>Asset Tag # / Serial #</th>
											<th></th>
										</tr>
									</thead>
									<tbody >
									@foreach($mergedData as $key => $data)
									<tr id="added-count-{{ $key +1 }}">
										<td>{{ $key +1 }}</td>
										<td class="asset-tag-value">{{$data->serial_no}}</td>
										<td></td>
										<input type="hidden" name="serial_no{{ $key +1 }}" value="{{$data->serial_no}}">
										<input type="hidden" name="count" value="{{ $key +1 }}">
									</tr>
									@endforeach
									@if($mergedData->isEmpty())	
									<input type="hidden" name="location_id" value="{{$locationId}}" >
									@endif
									</tbody>
								</table>
								<div class="row">
									<div class="col-xs-12 ">
										<a href="/inventory-control/cycle-count/merge/{{$locationId}}/{{$assetTypeId}}" name="commit" id="merge-button" role="button" class="btn btn-primary">Merge & Finalize Count</a>
										<button type="submit" name="commit" class="btn btn-primary">Generate Report</button>
									</div>
									 
								</div>						
							</form>
						@else

						<table class="table table-striped" id="asset-table">
							<thead>
								<tr>
									<th>#</th>
									<th>Asset Tag # / Serial #</th>
									<th></th>
								</tr>
							</thead>
							<tbody>
							</tbody>
						</table>
						<div class="row">
							<div class="col-md-9">
								<button class="btn btn-primary pull-left freeze-unfreeze" data-id="0" id="freeze" style="display:none;">Freeze</button>
								<button class="btn btn-primary pull-left freeze-unfreeze" data-id="1" id="unfreeze" style="display:none;">Unfreeze</button>
								<div id="freeze-info" style="display:none; margin-left:77px;">
									<i style="color:#0049B0;font-size:20px;padding:7px 5px" class="icon icon-c-question" data-toggle="tooltip" data-placement="top" 
									title="The freeze function will disable asset movement within the room. Assets cannot be assigned or returned until the count has been finalized"></i>
								</div>
							</div>
							<div class="col-md-3 text-right">
								<a href="/inventory-control/cycle-count/merge/" name="commit" id="merge-button" role="button" class="btn btn-primary">Merge & Finalize Count</a>
							</div>
						</div>	
						@endif
					</div>

				</div>

				<div class="ibox">

					<div class="ibox-title">
						<h5>Frozen Locations</h5>
					</div>

					<div class="ibox-content">

						<table class="table table-striped" id="frozen-locations">

							<thead>

								<tr>

									<th>Location</th>

									<th>Unfreeze</th>

								</tr>

							</thead>

							<tbody>

								@include('reports.cycle-count.partials.frozen-locations')

							</tbody>

						</table>
						<div class="pull-right">
							{{ $locations->links() }}
						</div>

					</div>

				</div>

			</div>

		</div>

	</div>

</div>

@include('reports.cycle-count.modals.confirm-unfreeze')
@include('reports.cycle-count.modals.confirm-merge')

@endsection

@section('help-links')
@include('help.help-links',['helpLink'=>config('help-links.help_links.cycle_count'),'helpTitle'=>config('help-links.help_titles.cycle_count')])
@endsection

@section('after_scripts')
	@include('assets.partials.scripts.common')
	@include('reports.cycle-count.scripts.cycle-count')
	@include('reports.cycle-count.scripts.cycle-count-form-submit-ajax', [
		'form_id' => 'varience-create-form',
		'route_name' => 'cycle-count.updateRows'
	])
@endsection
