@extends('layouts.main')
@section('content')
@include('reports.cycle-count.partials.cycle-count-submenu')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'Cycle Count', 'parentUrl' => '#', 'parentTitle' => 'Inventory Control'])

<div class="wrapper-content">
	<div class="container-fluid">
		<div class="ibox">
			<div class="ibox-title">
				<div class="ibox-tools">
					
					<button class="btn btn-primary btn-sm freeze-unfreeze" data-id="1" id="unfreeze" @if($location->is_freeze == 1)  style="margin-left: 10px; display:inline-block;" @else style="margin-left: 10px; display:none;" @endif>Unfreeze</button>
					
					{{-- <button id="download" class="btn btn-primary btn-sm downloadbtn">Download Report</button> --}}
					
					@if (Storage::disk('public')->exists($reportCsvFile))
					<a class="btn btn-primary btn-sm downloadbtn" href="/inventory-control/download-cycle-count-report/{{$reportId}}" download>Download Report</a>
					@endif
					
					<input type="hidden" name="location_id" id="location_id" value="{{ $location->id }}">
				</div>
			</div>
			<div class="ibox-content">
				<input type="hidden" id="reportName" value="{{ $reportName }}">
				
				<table class="dl-horizontal report" width="200">
					<tr>
						<th colspan="5">Date</th>
						
						<th colspan="3">{{$createdDate}}</th>
					</tr>
					
					<tr>
						<th colspan="5">Scanned by</th>
						
						<th colspan="3">{{$userName}}</th>
					</tr>
					
				</table>
				
				<div class="row m-t m-b">
					<div class="col-md-6">
						<table class="dl-horizontal report" width="300">
							<tr>
								<th>
									<i style="color:#0049B0;" class="icon icon-c-question" aria-hidden='true'  data-toggle="tooltip" data-placement="right" title="The total # of assets in Teqtivity within this location."></i> 
									Total # of Assets
								</th>
								<td>{{$count}}</td>
							</tr>
							<tr>
								<th>
									<i style="color:#0049B0;" class="icon icon-c-question" data-toggle="tooltip" data-placement="right" title="The total # of assets scanned that matched the assets in Teqtivity."></i>
									Total # of Assets Matched
								</th>
								<td>{{$assetsMatched}}</td>
							</tr>
							<tr>
								<th>
									<i style="color:#0049B0;" class="icon icon-c-question" data-toggle="tooltip" data-placement="right" title="The total # of assets that show a discrepancy."></i>
									Total # of Process Errors
								</th>
								<td>{{$positiveVariance}}</td>
							</tr>
							<tr>
								<th>
									<i style="color:#0049B0;" class="icon icon-c-question" data-toggle="tooltip" data-placement="right" title="The total # of assets that were not scanned and are physically missing."></i>
									Total # of Unknown Shrinkage
								</th>
								<td>{{$datasNotScanned->count()}}</td>
							</tr>
							<tr>
								<th>
									<i style="color:#0049B0;" class="icon icon-c-question" data-toggle="tooltip" data-placement="right" title="The percentage accuracy of the scan."></i>
									% of Accuracy
								</th>
								<td><span class="text-danger">{{$accuracy}}%</span></td>
							</tr>
							<tr>
								<th>
									<i style="color:#0049B0;" class="icon icon-c-question" data-toggle="tooltip" data-placement="right" title="The percentage of issues in the scan."></i>
									% of Variance
								</th>
								<td><span class="text-danger">{{$variance}}%</span></td>
							</tr>
						</table>
					</div>
				</div> 
				
				<table class="table table-striped nowrap report" data-page-size="50" id="varianceResultTable">
					
					<thead>
						
						<tr>
							
							<th>#</th>	
							
							<th>Scanned Asset Tag #</th>
							
							<th>Serial #</th>
							
							<th>Asset Type</th>
							
							<th>Hardware Standard</th>
							
							<th>Tech Spec</th>
							
							<th>Asset Status</th>
							
							<th>Asset Location</th>
							
							<th>Match at Location (Y/N)</th>
							
							<th>Discrepancy</th>
							
							<th>Error</th>
							
							<!--<th>Variance</th>-->
							
						</tr>
						
					</thead>
					
					<tbody>
						
						@foreach($datas as $data)
						<tr>
							<td>{{$loop->index+1}}</td>
							<td>{{$data['asset_tag']}}</td>
							<td>{{$data['serial_no']}}</td>
							<td>{{$data['asset_type']}}</td>
							<td>{{$data['hardware_standard']}}</td>
							<td>{{$data['technical_spec']}}</td>
							<td>{{$data['status']}}</td>
							<td>{{$data['location']}}</td>
							<td>{{$data['location_match']}}</td>
							<td>{{$data['discrepancy']}}</td>
							<td>{{$data['error']}}</td>
							
						</tr>
						@endforeach
						@foreach($dataNotInDatabase as $data)
						<tr>
							<td>{{count($datas) + $loop->index + 1}}</td>
							<td>{{$data['asset_tag']}}</td>
							<td>{{$data['serial_no']}}</td>
							<td>{{$data['asset_type']??''}}</td>
							<td>{{$data['hardware_standard']}}</td>
							<td>{{$data['technical_spec']}}</td>
							<td>{{$data['status']}}</td>
							<td>{{$data['location']}}</td>
							<td>{{$data['location_match']}}</td>
							<td>{{$data['discrepancy']}}</td>
							<td>{{$data['error']??''}}</td>
							
						</tr>
						@endforeach
						
						@forelse($datasNotScanned as $data)
						<tr>
							<td>{{count($datas) + count($dataNotInDatabase) + $loop->index + 1}}</td>
							<td>{{$data['asset_tag']}}</td>
							<td>{{$data['serial_no']}}</td>
							<td>{{$data['asset_type']??''}}</td>
							<td>{{$data['hardware_standard']}}</td>
							<td>{{$data['technical_spec']}}</td>
							<td>{{$data['status']}}</td>
							<td>{{$data['location']}}</td>
							<td>{{$data['location_match']}}</td>
							<td>{{$data['discrepancy']}}</td>
							<td>{{$data['error']??''}}</td>
							
						</tr>
						@empty
						@endforelse
						
					</tbody>
					
				</table>
				
				
				<div class="row m-t">
					<div class="col-md-6">
						<table class="dl-horizontal report" width="300">
							<tr>
								<th>
									<i style="color:#0049B0;" class="icon icon-c-question" aria-hidden='true'  data-toggle="tooltip" data-placement="right" title="The total # of assets in Teqtivity within this location."></i> 
									Total # of Assets
								</th>
								<td>{{$count}}</td>
							</tr>
							<tr>
								<th>
									<i style="color:#0049B0;" class="icon icon-c-question" data-toggle="tooltip" data-placement="right" title="The total # of assets scanned that matched the assets in Teqtivity."></i>
									Total # of Assets Matched
								</th>
								<td>{{$assetsMatched}}</td>
							</tr>
							<tr>
								<th>
									<i style="color:#0049B0;" class="icon icon-c-question" data-toggle="tooltip" data-placement="right" title="The total # of assets that show a discrepancy."></i>
									Total # of Process Errors
								</th>
								<td>{{$positiveVariance}}</td>
							</tr>
							<tr>
								<th>
									<i style="color:#0049B0;" class="icon icon-c-question" data-toggle="tooltip" data-placement="right" title="The total # of assets that were not scanned and are physically missing."></i>
									Total # of Unknown Shrinkage
								</th>
								<td>{{$datasNotScanned->count()}}</td>
							</tr>
							<tr>
								<th>
									<i style="color:#0049B0;" class="icon icon-c-question" data-toggle="tooltip" data-placement="right" title="The percentage accuracy of the scan."></i>
									% of Accuracy
								</th>
								<td><span class="text-danger">{{$accuracy}}%</span></td>
							</tr>
							<tr>
								<th>
									<i style="color:#0049B0;" class="icon icon-c-question" data-toggle="tooltip" data-placement="right" title="The percentage of issues in the scan."></i>
									% of Variance
								</th>
								<td><span class="text-danger">{{$variance}}%</span></td>
							</tr>
						</table>
					</div>
				</div> 
				
			</div>
			
		</div>
		
	</div>
	
</div>

</div>

</div>

@endsection

@section('help-links')
@include('help.help-links',['helpLink'=>config('help-links.help_links.cycle_count'),'helpTitle'=>config('help-links.help_titles.cycle_count')])
@endsection

@section('after_scripts')
@include('assets.partials.scripts.common')
<script src="/js/plugins/dataTables/datatables.min.js"></script>
<link href="/css/plugins/dataTables/fixedHeader.dataTables.min.css" rel="stylesheet">
<script>
	$(function () {
		$('[data-toggle="tooltip"]').tooltip();
		$('#varianceResultTable').DataTable({
			scrollX:false,
			scrollY:false,
			responsive: true,
			fixedHeader: true,
			paging: true,
			searching: false,
			ordering: false,
			"bInfo": false,
			"pageLength": 50
		});
	})
	
</script>
@endsection