@extends('layouts.main')
@section('content')
@include('reports.cycle-count.partials.cycle-count-submenu')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'Inventory Report Details', 'parentUrl' => '/inventory-control/inventory-report', 'parentTitle' => 'Inventory Report'])

<div class="wrapper-content">

	<div class="container-fluid">

		<div class="row">

			<div class="col-lg-12">

				<div class="ibox">

					<div class="ibox-content">
						<dl class="dl-horizontal custom-dl">
						@if($history->name)
							<dt>Report Name</dt>
							<dd>{{$history->name}}</dd>
						@endif
							<dt>Location</dt>
							<dd>{{$history->location_name}}</dd>
							
							<dt>Asset types selected</dt>
							<dd>{{$assetTypes}}</dd>

							<dt>Scanned by</dt>
							<dd>{{$history->scanned_by}}</dd>

							<dt>Date Scanned</dt>
							<dd>{{$history->date}}</dd>

							<dt>Total # of Assets</dt>
							<dd>{{$history->total_assets}}</dd>

							<dt>Total # of assets physically scanned</dt>
							<dd>{{$history->total_assets_scanned}}</dd>

							<dt>Total # of Assets Matched</dt>
							<dd>{{$history->match_y}}</dd>
							
							{{-- Assets scanned but not present + assets scanned bit in another location --}}
							<dt>Total # of Process Errors</dt>
							<dd>{{$history->positive_variance}}</dd>

							{{-- assets not scanned  --}}
							<dt>Total # of Unknown Shrinkage</dt> 
							<dd>{{$history->assets_not_scanned ?? ''}}</dd>

							<dt>
								<span class="font-size-15"> % of Accuracy </span>
							</dt>
							<dd>
								<span class="text-danger font-size-15">
									{{$history->accuracy}}%
								</span>
							</dd>

							<dt>
								<span class="font-size-15"> % of Variance </span>
							</dt>
							<dd>
								<span class="text-danger font-size-15">
									{{ $history->variance }}%
								</span>
							</dd>
						</dl>

						@if($history->report_csv)
							<div class="" style="margin-top: 30px">
	                            <a href="/inventory-control/download-cycle-count-report/{{$history->id}}" id="" class="btn btn-primary">Download Report</a>
	                        </div>
	                    @endif

					</div>

				</div>

			</div>

		</div>

	</div>

</div>

@endsection
@section('help-links')
@include('help.help-links',['helpLink'=>config('help-links.help_links.cycle_count'),'helpTitle'=>config('help-links.help_titles.cycle_count')])
@endsection

@section('after_scripts')
	@include('assets.partials.scripts.common')
	<style>
		.font-size-15 {
			font-size:15px;
		}
	</style>
	   
@endsection
