@extends('layouts.main')
@section('content')

@include('partials.breadcrumb', ['breadcrumbTitle' => 'Inventory Report', 'parentUrl' => '/inventory-control/cycle-count', 'parentTitle' => 'Cycle Count'])
@include('reports.cycle-count.partials.cycle-count-submenu')

<div class="wrapper-content">
    <div class="container-fluid">
        <div class="row">
            @include('reports.cycle-count.partials.cycle-count-history-filter')
        </div> 
        <div class="row">
            <div class="col-lg-12">
                <div class="ibox">
                    <div class="ibox-content">
                        
                            <div class="row" id="average-values-box" style="display:none">
                                <div class="col-lg-3">
                                    <div class="widget style1 bg-info">
                                        <div class="row">
                                            <div class="col-xs-4">
                                                <i class="icon icon-analytics icon-32"></i>
                                            </div>
                                            <div class="col-xs-8 text-right">
                                                <h3 class="">Average Accuracy</h3>
                                                <h2 class="font-bold" id="variance-history-average"></h2>
                                                <span>&nbsp;</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-lg-3">
                                        <div class="widget style1 bg-success">
                                        <div class="row">
                                            <div class="col-xs-4">
                                                <i class="icon icon-box-arrow-up icon-32"></i>
                                            </div>
                                            <div class="col-xs-8 text-right">
                                                <h3 class="">Highest Accuracy</h3>
                                                <h2 class="font-bold" id="variance-heighest-accuracy"></h2>
                                                <span id="variance-heighest-date"></span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-3">
                                        <div class="widget style1 bg-warning">
                                        <div class="row">
                                            <div class="col-xs-4">
                                                <i class="icon icon-box-arrow-down icon-32"></i>
                                            </div>
                                            <div class="col-xs-8 text-right">
                                                <h3 class="">Lowest Accuracy</h3>
                                                <h2 class="font-bold" id="variance-lowest-accuracy"></h2>
                                                <span id="variance-lowest-date"></span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row" style="margin-top: 100px" id="variance-graph-container" style="display:none">
                                <div class="col-lg-12">
                                    <div id="morris-cycle-count-accuracy-chart"></div>
                                </div>
                            </div>                             
                                               

                        <div class="table-responsive" style="margin-top: 100px">
                            
                            <table class="footable table table-stripped table-hover" data-page-size="50" data-filter=#filter>

                                <thead>

                                    <tr>

                                        <th>#</th>

                                        <th>Room Name</th>

                                        <th>Date</th>

                                        <th>Asset Types Searched</th>

                                        <th>% of Accuracy</th>                                    

                                    </tr>

                                </thead>

                                <tbody>
                                    

                                </tbody>

                            </table>
                        </div>

                    </div>

                </div>

            </div>

        </div>

    </div>

</div>
@stop

@section('help-links')
@include('help.help-links',['helpLink'=>config('help-links.help_links.cycle_count'),'helpTitle'=>config('help-links.help_titles.cycle_count')])
@endsection

@section('after_scripts')
@include('reports.cycle-count.scripts.cycle-count-history')

@stop