<script>

    $(document).ready(function() {

        var table = $('.footable').DataTable({
            responsive:false,
			fixedHeader:true,
			"scrollX": true,
			fixedColumns: true,
			fixedColumns: {
				left: 3
			},
            "processing": true,
            "serverSide": true,
            "ajax":{
                "url": "{{ route('deployment-data') }}",
                "dataType": "json",
                "type": "POST",
                "data": function( result ) {
                    result.form = $('#search-form').serializeObject();
                }
            },
            "columns": [
                { "data": "id" },
                { "data": "asset_tag" },
                { "data": "serial_no" },
                { "data": "manufacturer" },
                { "data": "make_and_model" },
                { "data": "technical_specs" },
                { "data": "user_location" },
                { "data": "work_location" },
                { "data": "date_assigned" },

            ],
            lengthMenu: [
				[10, 25, 50, 100],
            	[10, 25, 50, 100]
			],
			iDisplayLength: 50,
            columnDefs: [
               { orderable: false, targets: "_all" }
            ],
            "aaSorting": [],
            "bAutoWidth": false,
            "bFilter": true,
            "searching": false,
            fnDrawCallback: function(oSettings) {
                if (oSettings._iRecordsDisplay == 0) {
                    $("#export-csv").hide();
                } else {
                    $("#export-csv").show();
                }
            }
        });

        // Data table column toggle
        $('span.col-toggle').on('click', function (e) {
            e.preventDefault();
            $(this).toggleClass('col-hidden');
            // Get the column API object
            var column = table.column($(this).attr('data-column'));

            // Toggle the visibility
            column.visible(!column.visible());
        });

        $('#search-form').submit(function (e) {
            e.preventDefault();
            table.draw();
        });

        $('#export-csv').on('click', function(e) {
            e.preventDefault();
            $('.ajax-loader').show();
            $.ajax({
                type: "POST",
                url: "{{ route('deployment-export') }}",
                data: $('#search-form').serializeObject(),
                dataType: 'text',
                success: function(result) {
                    var blob = new Blob([result]);
                    var filename = "computers-deployed.csv"
                    if (window.navigator.msSaveOrOpenBlob)  // IE hack; see http://msdn.microsoft.com/en-us/library/ie/hh779016.aspx
                        window.navigator.msSaveBlob(blob, filename);
                    else
                    {
                        var a = window.document.createElement("a");
                        a.href = window.URL.createObjectURL(blob, {type: "text/plain"});
                        a.download = filename;
                        document.body.appendChild(a);
                        a.click();  // IE: "Access is denied"; see: https://connect.microsoft.com/IE/feedback/details/797361/ie-10-treats-blob-url-as-cross-origin-and-denies-access
                        document.body.removeChild(a);
                    }
                    $('.ajax-loader').hide();
                }
            })
        });


        $("#make_and_model").change(function(){
            if ($(this).val() != '' && $(this).val() != '--Select--' && $(this).val() != '0') {
                $.ajax({
                    type: "POST",
                    data:{id:$(this).val()},
                    url: "/assets-filter/listtechnics",
                    success: function(data) {
                        $('#technical_spec').empty();
                        $('#technical_spec').append($('<option>', {
                            value: 0,
                            text: "--Select--"
                            }));
                        $("#technical_spec").select2();
                        $.each(data,function (key,value) {
                            $('#technical_spec').append($('<option>', {
                            value: value.id,
                            text: value.details
                            }));
                        });
                    },
                    error: function(value) {

                    }
                });
            }
        });

    });


</script>