<div class="col-lg-12">
    <div class="ibox">
        <div class="ibox-title">
            <div class="ibox-tools">
                <h5>Filters</h5>
                <a data-toggle="collapse" href="#collapseFilter" class="collapse-link">
                    <i class="icon icon-e-delete"></i>
                </a>
            </div>
        </div>
        <div class="collapse in" id="collapseFilter">

            <div class="ibox-content">
                <form method="post" id="search-form" action="">
                    {{ csrf_field() }}
                    <div class="row">
                        <div class="col-md-3">
							<div class="form-group">
								<label class="control-label">Asset Tag # </label>
								<select class="filter-field form-control" id="asset_tag" multiple name="asset_tag"
									data-placeholder="Select" key="asset_tag">
								</select>
							</div>
						</div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label class="control-label">Serial #</label>
                                <select class="filter-field form-control" multiple name="serial_no" id="serial_no" key="serial_no" data-placeholder="Select">
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label class="control-label">Manufacturer</label>
                                <select class="form-control select2 filter" multiple name="manufacturer" id="manufacturer" data-placeholder="Select">
                                @foreach(\App\Models\Manufacturer::orderBy('name')->get() as $manufacturer)
                                    <option value="{{$manufacturer->id}}">{{$manufacturer->name}}</option>
                                @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label class="control-label">Hardware Standard</label>
                                <select class="form-control select2" multiple name="make_and_model_id" id="make_and_model" data-placeholder="Select">
                                    @foreach(\App\Models\MakeAndModel::valid()->orderBy('name')->get() as $hardware)
                                    <option value="{{$hardware->id}}">{{ $hardware->name }}</option>
                                    @endforeach

                                </select>
                            </div>
                        </div>

                        <div class="col-md-3">
                            <div class="form-group">
                                <label class="control-label">Technical Specs</label>
                                <select class="form-control select2" multiple name="technical_spec_id" id="technical_spec" data-placeholder="Select">
                                    @foreach(\App\Models\TechnicalSpecs::valid()->orderBy('details')->get() as $technicalSpec)
                                        <option value="{{$technicalSpec->id}}">{{ $technicalSpec->details}}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label class="control-label">User</label>
                                <select class="filter-field-user select2 form-control filter-input" multiple name="user" id="user" key="user" data-placeholder="Select">
                                </select>
                            </div>
                        </div>

                        <div class="col-md-3 divHeight">
							<div class="form-group">
								<label class="control-label">Location </label>
								<select class="filter-field-location form-control" multiple name="location_id" id="location" key="room_name" data-placeholder="Select">
								</select>
							</div>
						</div>
                        <div class="col-md-3 divHeight">
                            <div class="form-group">
                                <label class="control-label">Work Location</label>
                                <select class="filter-field-location form-control" multiple name="work_location" key="city" id="work_location" data-placeholder="Select">
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>Date Assigned Range</label>
                                <div class="form-group">
                                    <div class="input-group date">
                                        <span class="input-group-addon"><i class="icon icon-calendar-2"></i></span>
                                        <input type="text" name="assigned_date_from" id="assigned_date_from" class="form-control readonly-white" placeholder="From" value="" readonly>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <div class="input-group date">
                                        <span class="input-group-addon"><i class="icon icon-calendar-2"></i></span>
                                        <input type="text" class="form-control readonly-white" id="assigned_date_to" placeholder="To" name="assigned_date_to" value="" readonly>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                </form>
            </div>
        </div>
    </div>
</div>