@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'Computers Deployed', 'parentUrl' => '/report', 'parentTitle' => 'Reports'])
<div class="wrapper-content">
    <div class="container-fluid">
        <div class="row">
            @include('reports.computer-deployed.partials.filters')
            <div class="col-lg-12">
                <div class="ibox">
                    <div class="ibox-title">
                        <div class="ibox-tools">
                            <button type="button" id="export-csv" class="btn btn-primary">Export to CSV</button>
                        </div>
                    </div>
                    <div class="ibox-content">
                        @include('partials.success')
                        @include('partials.error-message')
                        <div class="ajax-loader"><img src="/img/ajax-loader-full-width.gif"></div>
                        <div class="dt-coltoggler-wrapper ">
                            <p>Click to toggle table columns: </p>
                        </div>

                        <div class="table-responsive">
                            <table class="footable table table-stripped table-hover nowrap three-col-fixed has-column-toggler" data-page-size="50" data-filter=#filter>
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>Asset Tag #</th>
                                        <th>Serial #</th>
                                        <th>Manufacturer</th>
                                        <th>Hardware Standard</th>
                                        <th>Technical Specs</th>
                                        <th>User/Location</th>
                                        <th>Work Location</th>
                                        <th>Date Assigned</th>
                                    </tr>
                                </thead>
                            </table>
                        </div>

                    </div>

                </div>

            </div>

        </div>

    </div>

</div>
@stop

@section('after_scripts')

@include('reports.scripts.common')
@include('reports.scripts.datatable-column-toggle-script');
@include('reports.scripts.filter-options-with-ajax')
@include('reports.computer-deployed.scripts.script')

@stop