<div class="col-lg-12">
    <div class="ibox">
        <div class="ibox-title">
            <div class="ibox-tools">
                <h5>Filters</h5>
                <a data-toggle="collapse" href="#collapseFilter" class="collapse-link"> <i class="icon icon-e-delete"></i></a>
            </div>
        </div>
        <div class="collapse in" id="collapseFilter" aria-expanded="true">
            <div class="ibox-content">
                <form method="post" id="search-form" action="">
                    {{ csrf_field() }}
                    <div class="row">

                        <div class="col-md-3">
                            <div class="form-group">
                                <label class="control-label">Asset Type</label>
                                <select class="form-control select2 filter" multiple name="asset_type" id="asset_type" data-placeholder="Select">
                                    @foreach(\App\Models\AssetType::orderBy('name')->get() as $assetType)
                                    <option value="{{$assetType->id}}" {{ isset($search['asset_type']['asset_type_id']) ? in_array($assetType->id, $search['asset_type']['asset_type_id']) ? "selected" : "" : "" }}>{{$assetType->name}}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>

                        <div class="col-md-3">
                            <div class="form-group">
                                <label class="control-label">Manufacturer</label>
                                <select class="form-control select2 filter" multiple name="manufacturer" id="manufacturer" data-placeholder="Select">
                                    @foreach(\App\Models\Manufacturer::orderBy('name')->get() as $manufacturer)
                                    <option value="{{$manufacturer->id}}"
									{{$search ?
										(isset($search['manufacturer']['manufacturer_id']) ?
                                            (is_array($search['manufacturer']['manufacturer_id']) ?
                                                (in_array($manufacturer->id, $search['manufacturer']['manufacturer_id']) ?
                                                    'selected' : "")
                                                : (($manufacturer->id == $search['manufacturer']['manufacturer_id']) ? 'selected' : ""))
                                            : "")
										: ""
									}}
                                    >{{$manufacturer->name}}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>

                        <div class="col-md-3">
                            <div class="form-group">
                                <label class="control-label">Hardware Standard</label>
                                <select class="form-control select2 filter" multiple name="make_and_model" id="make_and_model" data-placeholder="Select">
                                    @foreach(Facades\App\Repositories\HardwareStandards::getHardwareStandardsWithoutAccessories() as $hardware)
                                    <option value="{{$hardware->id}}" {{ isset($search['make_and_model']['make_and_model_id']) ? in_array($hardware->id, $search['make_and_model']['make_and_model_id']) ? "selected" : "" : "" }}>{{$hardware->manufacturer}} - {{$hardware->makeAndModel}}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>

                        <div class="col-md-3">
                            <div class="form-group">
                                <label class="control-label">Asset Status</label>
                                <select class="form-control select2 filter" multiple name="status" id="status" data-placeholder="Select">
                                    @foreach(\App\Models\AssetStatus::orderBy('name')->get() as $status)
                                        <option value="{{$status->id}}" {{ isset($search['asset_status_id']['asset_status_id']) ? in_array($status->id, $search['asset_status_id']['asset_status_id']) ? "selected" : "" : "" }}>{{$status->name}}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>

                    </div>
                </form>
            </div>
        </div>
    </div>
</div>