@extends('layouts.main')
@section('content')

@include('partials.breadcrumb', ['breadcrumbTitle' => 'Computers', 'parentUrl' => '/report', 'parentTitle' => 'Reports'])
<div class="wrapper-content">

    <div class="container-fluid">
        <div class="row">
            @include('reports.computer-by-status.partials.computer-by-status-filter')
            <div class="col-lg-12">
                <div class="ibox">
                    <div class="ibox-title">
                        <div class="ibox-tools">
                            <button type="button" id="export-csv" class="btn btn-primary" data-url="{{ route('computer-by-status-export') }}" data-file-name="computer-report-export">Export to CSV</button>
                        </div>
                    </div>
                    <div class="ibox-content">
                        @include('partials.success')
                        @include('partials.error-message')
                        <div class="ajax-loader"><img src="/img/ajax-loader-full-width.gif"></div>
                        <table class="footable table table-stripped table-hover nowrap four-col-fixed" data-role="ui-data-table" data-url="{{ route('computers-report-data') }}" data-searching="false" data-ordering="false" data-page-size="50" data-fixed-header="true" data-fixed-header-columns-left="4">
                            <thead>
                                <tr>
                                    <th data-col-name="id">#</th>
                                    <th data-col-name="type">Type</th>
                                    <th data-col-name="asset_tag">Asset Tag # </th>
                                    <th data-col-name="serial_number">Serial #</th>
                                    <th data-col-name="child_asset">Child Asset # </i></th>
                                    <th data-col-name="hardware_standard">Hardware Standard </i></th>
                                    <th data-col-name="technical_spec">Tech Specs </i></th>
                                    <th data-col-name="po_number">PO #</th>
                                    <th data-col-name="asset_status">Asset Status </i></th>
                                    <th data-col-name="user_location">User/Location</i></th>
                                    <th data-col-name="warranty_end_date">Warranty End Date</i></th>
                                    <th data-col-name="age">Asset Age </i></th>
                                    <th data-col-name="modified_date">Last Modified Date </i></th>
                                    <th data-col-name="modified_by">Last Modified By </i></th>
                                </tr>
                            </thead>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@stop

@section('after_scripts')

@include('reports.scripts.common')
@include('reports.scripts.datatable')
@include('reports.computer-by-status.scripts.computer-by-status')

@stop