<script src="/js/plugins/chosen/chosen.jquery.js"></script>
<script src="/js/plugins/chosen/chosen.ajaxaddition.jquery.js"></script>
<script>
$(document).ready(function() {
    $('.chosen-select').chosen({
        width: "100%"
    }).change(function() {
        $(this).closest('.form-group').next().find('input').focus();
    });

    $(".filter-field-location").each(function() {
        var name = $(this).attr('key');
        $( this ).select2({
            minimumInputLength: 1,
            multiple: true,
            ajax: {
                url: '/get-filter-fields-location',
                dataType: "json",
                data: function (params){
                    var query = {
                    search: params.term,
                    type: name
                    }

                    // Query parameters will be ?search=[term]&type=public
                    return query;
                },
                processResults: function (data) {
                    // Tranforms the top-level key of the response object from 'items' to 'results'
                    return {
                    results: data
                    };
                },

            }
        });
    });

    $(".filter-field").each(function() {
        var name = $(this).attr('key');
        $(this).select2({
            minimumInputLength: 1,
            multiple: true,
            ajax: {
                url: '/get-filter-fields',
                dataType: "json",
                data: function(params) {
                    var query = {
                        search: params.term,
                        type: name
                    }

                    // Query parameters will be ?search=[term]&type=public
                    return query;
                },
                processResults: function(data) {
                    // Tranforms the top-level key of the response object from 'items' to 'results'
                    return {
                        results: data
                    };
                },

            }
        });
    });

    var delay = (function() {
        var timer = 0;
        return function(callback, ms) {
            clearTimeout(timer);
            timer = setTimeout(callback, ms);
        };
    })();

    $("#status, #serial_no, #asset_tag, #user, #location, #make_and_model, #technical_spec, #asset_age, #work_location").on('change', function() {
        $('#search-form').submit();
    });


    $("#make_and_model").change(function() {
        if ($(this).val() != '' && $(this).val() != '--Select--' && $(this).val() != '0') {
            $.ajax({
                type: "POST",
                data: {
                    id: $(this).val()
                },
                url: "/assets-filter/listtechnics",
                success: function(data) {
                    $('#technical_spec').empty();
                    $('#technical_spec').append($('<option>', {
                        value: 0,
                        text: "--Select--"
                    }));
                    $("#technical_spec").select2();
                    $.each(data, function(key, value) {
                        $('#technical_spec').append($('<option>', {
                            value: value.id,
                            text: value.details
                        }));
                    });
                },
                error: function(value) {

                }
            });
        }else{
            $('#technical_spec').empty();
        }
    });

    $(".filter-field-user").each(function() {
        $( this ).select2({
            minimumInputLength: 1,
            multiple: true,
            ajax: {
                url: '/get-filter-fields-user',
                dataType: "json",
                data: function (params){
                    var query = {
                    search: params.term
                    }

                    // Query parameters will be ?search=[term]&type=public
                    return query;
                },
                processResults: function (data) {
                    // Tranforms the top-level key of the response object from 'items' to 'results'
                    return {
                    results: data
                    };
                },

            }
        });
    });

    $(".filter-field").each(function() {
        var name = $(this).attr('key');
        $(this).select2({
            minimumInputLength: 1,
            multiple: true,
            ajax: {
                url: '/get-filter-fields',
                dataType: "json",
                data: function(params) {
                    var query = {
                        search: params.term,
                        type: name
                    }

                    // Query parameters will be ?search=[term]&type=public
                    return query;
                },
                processResults: function(data) {
                    // Tranforms the top-level key of the response object from 'items' to 'results'
                    return {
                        results: data
                    };
                },

            }
        });
    });
});
</script>