@extends('layouts.main')
@section('content')



@include('partials.breadcrumb', ['breadcrumbTitle' => 'Computers By Age', 'parentUrl' => '/report', 'parentTitle' => 'Reports'])
<div class="wrapper-content">

    <div class="container-fluid">
        @include('reports.computer-by-age.partials.computer-by-age-filter')
        <div class="ibox">
            <div class="ibox-title">
                <div class="ibox-tools">
                    <button type="button" id="export-csv" class="btn btn-primary" data-url="{{ route('computer-by-age-export') }}" data-file-name="computers-by-age-report-export">Export to CSV</button>
                </div>
            </div>
            <div class="ibox-content">
                @include('partials.success')
                @include('partials.error-message')
                <div class="ajax-loader"><img src="/img/ajax-loader-full-width.gif"></div>
                <div class="dt-coltoggler-wrapper ">
					<p>Click to toggle table columns: </p>
                </div>
                <table class="footable table table-stripped table-hover nowrap three-col-fixed has-column-toggler" data-role="ui-data-table" data-url="{{ route('computer-by-age-data') }}" data-searching="false" data-ordering="false" data-page-size="50" data-fixed-header="true" data-fixed-header-columns-left="3">
                    <thead>
                        <tr>
                            <th data-col-name="id">#</th>
                            <th data-col-name="asset_tag">Asset Tag #</th>
                            <th data-col-name="serial_no">Serial #</th>
                            <th data-col-name="hardware_standard">Hardware Standard</th>
                            <th data-col-name="tech_specs">Technical Specs</th>
                            <th data-col-name="user_location">User / Location</th>
                            <th data-col-name="user_work_location">User Work Location</th>
                            <th data-col-name="asset_status">Asset Status</th>
                            <th data-col-name="created_date">Date Created</th>
                            <th data-col-name="age">Asset Age</th>
                        </tr>
                    </thead>
                </table>
            </div>
        </div>
    </div>
</div>
@stop

@section('after_scripts')

@include('reports.scripts.common')
@include('reports.scripts.datatable')
@include('reports.scripts.datatable-column-toggle-script')
@include('reports.computer-by-age.scripts.computer-by-age')

@stop