<div class="col-lg-12">
    <div class="ibox">
        <div class="ibox-title">
            <div class="ibox-tools">
                <h5>Filters</h5>
                <a data-toggle="collapse" href="#collapseFilter" class="collapse-link"
                    ><i class="icon icon-e-delete"></i></a>
            </div>
        </div>
        <div class="collapse in" id="collapseFilter" aria-expanded="true">
            <div class="ibox-content">
                <form action="{{ route('brandnew-to-assigned-graph-data') }}" method="post" id="search-form">
                    {{csrf_field()}}
                    <div class="row">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label class="control-label">Asset Type </label>
                                <select class="chosen-select"  multiple="" id="asset_type"  name="asset_type_id[]" data-placeholder="Select">
                                    @foreach(\App\Models\AssetType::valid()->orderBy('name', 'ASC')->get(); as $assetType)
                                        <option value="{{$assetType->id}}">{{$assetType->name}}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>

                        <div class="col-md-3">
                            <div class="form-group">
                                <label>Hardware Standard</label>
                                <select class="form-control select2"  multiple=""  name="make_and_model_id[]" id="make_and_model" data-placeholder="Select">
                                    @foreach(\App\Models\MakeAndModel::valid()->orderBy('name', 'ASC')->get(); as $hardware)
                                    <option value="{{$hardware->id}}">{{$hardware->name}}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>

                        <div class="col-md-3">
                            <div class="form-group">
                                <label>Technical Specs</label>
                                <select class="form-control select2"  multiple=""  name="technical_spec[]" id="technical_spec" data-placeholder="Select">
                                @foreach(\App\Models\TechnicalSpecs::valid()->orderBy('details', 'ASC')->get(); as $technicalSpec)
                                    <option value="{{$technicalSpec->id}}">{{$technicalSpec->details}}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>

                        <div class="col-md-3">
                            <div class="form-group">
                                <label>Storage Location</label>
                                <select class="form-control select2"  multiple=""  name="old_location_id[]" id="location" data-placeholder="Select" >
                                    @foreach(\App\Models\Location::Warehouses()->orderBy('room_name')->get() as $location)
                                    <option value="{{$location->id}}"
                                        @if(is_array(request('old_location_id')) && in_array($location->id,request('old_location_id'))) selected="selected" @endif
                                    >{{$location->room_name}}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>

                    </div>
                    <div class="row">

                        <div class="col-md-3">
                            <div class="form-group">
                                <label>Year</label>
                                @php
                                $now = \Carbon\Carbon::now();
                                $startYear = $now->year;
                                $endYear = $now->subYears(5)->year;
                                @endphp
                                <select name="year" class="form-control" id="year">
                                    @for($i = $startYear; $i > $endYear; $i-- )
                                    <option @if($i==$year) selected @endif value="{{$i}}">{{$i}}</option>
                                    @endfor
                                </select>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>