<!-- Morris -->
<script src="/js/plugins/morris/raphael-2.1.0.min.js"></script>
<script src="/js/plugins/morris/morris.min.js"></script>

<script>

var pageTheme = window.themeType;

// Define a property with a setter function for window.themeType
Object.defineProperty(window, 'themeType',{
    set: function(newValue) {
		pageTheme = newValue;
		$("#search-form").submit();
    }
});


$("#search-form").on('submit', function(e) {
	e.preventDefault();
	loadPageContent($(this));
});

// load graph and table data
function loadPageContent(searchFormObject)
{
    $('.ajax-loader').show();
	$('#sync-error').hide();
	$('#sync-error-msg').text("");
    
	
	$.ajax({
		url: searchFormObject.attr('action'),
		method: searchFormObject.attr('method'),
		data: searchFormObject.serializeObject(),
		dataType: "JSON",
		success: function (response) {

			$('.ajax-loader').hide();
			
			var months = response.averageTimeIndepotData.months;

			$('#monthly-avg-assets').empty();

			Morris.Line({
				element: 'monthly-avg-assets',
				data: response.averageTimeIndepotData.avg_time,
				xkey: 'yearMonth',
				ykeys: ['avg_time'],
				labels: ['Avg Time'],
				yLabelFormat: function(y) {
					return y + " Days";
				},
				xLabelAngle: 0,
				resize : true,
				xLabelFormat: function(x) {
					var month = months[x.getMonth()];
					return month;
				},
				dateFormat: function(x) {
					var month = months[new Date(x).getMonth()];
					return month;
				},
				lineColors: pageTheme == 'dark' ? ["{{ config('graph-settings.MorrislineColorsDark') }}"] : ["{{ config('graph-settings.MorrislineColors') }}"],
			});

		},
		error: function (response) {
			$('.ajax-loader').hide();
			$('#sync-error').show();
			$('#sync-error-msg').text("{{ config('graph-settings.graphRequestError') }}");
		}
	})
}

$(document).ready(function () {
	loadPageContent($("#search-form"));
});
</script>