<script>

    $(document).ready(function() {

        var table = $('.footable').DataTable({
            paging: true,
            "processing": true,
            "serverSide": true,
            "scrollX": true,
            scrollY: '400px',
            scrollCollapse: true,
            fixedColumns: true,
			fixedColumns: {
				left: 3
			},
            "ajax":{
                "url": "{{ route('available-stock-data') }}",
                "dataType": "json",
                "type": "POST",
                "data": function( result ) {
                    result.form = $('#search-form').serializeObject();
                }
            },
            "columns": [
                { "data": "id" },
                { "data": "asset_type" },
                { "data": "manufacturer" },
                { "data": "hardware_standard" },
                { "data": "tech_specs" },
                { "data": "asset_status" },
                { "data": "site_code" },
                { "data": "location" },
                { "data": "country" },
                { "data": "region" },
                { "data": "asset_count" },
            ],
            columnDefs: [
               { 'orderable': false, 'targets': '_all'}
            ],
            "aaSorting": [],
            "bAutoWidth": false,
            "searching": false,
            lengthMenu: [
                [10, 25, 50, 100],
            	[10, 25, 50, 100]
            ],
            iDisplayLength: 50,
            "fnDrawCallback": function( settings ){
                if (settings.json && settings.json.value != null) {
                    $("#widget_asset_total").html(settings.json.value.toLocaleString());
                    $("#widget_asset_total").show();

                    if (settings._iRecordsDisplay == 0) {
                        $("#export-csv").hide();
                    } else {
                        $("#export-csv").show();
                    }
                }
            },
        });

        $('#export-csv').on('click', function(e) {
            e.preventDefault();
            $('.ajax-loader').show();
            $.ajax({
                type: "POST",
                url: "{{ route('available-stock-export') }}",
                data: $('#search-form').serializeObject(),
                dataType: 'text',
                success: function(result) {
                    var blob = new Blob([result]);
                    var filename = "available-stock-export.csv"
                    if (window.navigator.msSaveOrOpenBlob)
                        window.navigator.msSaveBlob(blob, filename);
                    else
                    {
                        var a = window.document.createElement("a");
                        a.href = window.URL.createObjectURL(blob, {type: "text/plain"});
                        a.download = filename;
                        document.body.appendChild(a);
                        a.click();
                        document.body.removeChild(a);
                    }
                    $('.ajax-loader').hide();
                }
            })
        });

        $('#search-form').submit(function (e) {
            e.preventDefault();
            table.draw();
        });

        // Data table column toggle
        $('span.col-toggle').on('click', function (e) {
            e.preventDefault();
            $(this).toggleClass('col-hidden');
            // Get the column API object
            var column = table.column($(this).attr('data-column'));

            // Toggle the visibility
            column.visible(!column.visible());
        });

    });

</script>