<div class="ibox">
    <div class="ibox-title">
        <div class="ibox-tools">
            <h5>Filters</h5>
            <a data-toggle="collapse" href="#collapseFilter" class="collapse-link"
           ><i class="icon icon-e-delete"></i></a>
        </div>
    </div>
    <div class="collapse in" id="collapseFilter" aria-expanded="true">
        <div class="ibox-content">
            <form method="post" id="search-form" action="">
                {{ csrf_field() }}
                <div class="row">
                    <div class="col-md-3">
                        <div class="form-group">
                            <label class="control-label">Asset Type </label>
                            <select class="form-control select2 report-filter" id="asset_type" multiple name="asset_type_id" data-placeholder="Select">
                                    @foreach($filterDataOptions['assetTypes'] as $assetType)
                                        <option value="{{$assetType->id}}">{{$assetType->name}}</option>
                                    @endforeach
                            </select>
                        </div>
                    </div>

                    <div class="col-sm-3 divHeight">
                        <div class="form-group">
                            <label class="control-label">Manufacturer</label>
                            <select class="form-control select2 report-filter" id="manufacturer" multiple name="manufacturer_id" data-placeholder="Select">
                                @foreach($filterDataOptions['manufacturers'] as $manufacturer)
                                    <option value="{{$manufacturer->id}}">{{$manufacturer->name}}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>

                    <div class="col-md-3">
                        <div class="form-group">
                            <label class="control-label">Hardware Standard</label>
                            <select class="form-control select2 report-filter" multiple name="make_and_model_id" id="make_and_model" data-placeholder="Select">
                                @foreach($filterDataOptions['hardwareStds'] as $hardware)
                                    <option value="{{$hardware->id}}">{{$hardware->name}}</option>
                                @endforeach

                            </select>
                        </div>
                    </div>

                    <div class="col-md-3">
                        <div class="form-group">
                            <label class="control-label">Technical Specs</label>
                            <select class="form-control select2 report-filter" multiple name="technical_spec_id" id="technical_spec" data-placeholder="Select">
                                @foreach($filterDataOptions['techSpecs'] as $technicalSpec)
                                    <option value="{{$technicalSpec->id}}">{{ $technicalSpec->details}}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-sm-3 divHeight">
                        <div class="form-group">
                            <label class="control-label">Asset Status</label>
                            <select class="chosen-select report-filter" multiple name="asset_status_id" id="asset_status" data-placeholder="Select">
                                @foreach($filterDataOptions['statuses'] as $status)
                                    <option value="{{$status->id}}">{{$status->name}}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label class="control-label">Site Code</label>
                            <select class="chosen-select report-filter" multiple name="site_code_id" id="siteCode" data-placeholder="Select">
                                @foreach($filterDataOptions['siteCodes'] as $siteCode)
                                    <option value="{{$siteCode->id}}">{{$siteCode->code}}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="col-sm-3 divHeight">
                        <div class="form-group">
                            <label class="control-label">Location</label>
                            <select class="chosen-select report-filter" id="location" multiple name="location_id" data-placeholder="Select">
                                @foreach($filterDataOptions['locations'] as $location)
                                    <option value="{{$location->id}}">{{$location->room_name}}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>

                    <div class="col-sm-3 divHeight">
                        <div class="form-group">
                            <label class="control-label">Location Status</label>
                            <select class="chosen-select report-filter" id="location_status" name="location_status" data-placeholder="Select">
                             <option value="">--Select--</option>
                             <option value="active">Active</option>
                             <option value="inactive">Inactive</option>
                            </select>
                        </div>
                    </div>

                    <div class="col-sm-3 divHeight">
                        <div class="form-group">
                            <label class="control-label">Country</label>
                            <select class="chosen-select report-filter" id="country" multiple name="country_id" data-placeholder="Select">
                                @foreach($filterDataOptions['countries'] as $country)
                                    <option value="{{$country->id}}">{{$country->name}}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>

                    <div class="col-sm-3 divHeight">
                        <div class="form-group">
                            <label class="control-label">Region</label>
                            <select class="chosen-select report-filter" id="region" multiple name="region_id" data-placeholder="Select">
                                @foreach($filterDataOptions['regions'] as $region)
                                    <option value="{{$region->id}}">{{$region->name}}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
