@if(!empty($assetTypes))
<div class="ibox">
    <div class="ibox-title">
        <div class="ajax-loader ajax-loader-graph-export"><img src="/img/ajax-loader-full-width.gif"></div>
    </div>
    <div class="ibox-content">
        <div class="row animated fadeInRight">
            @foreach($assetTypes as $assetType)
                <div class="{{$assetTypes->count() == 1 ? 'col-lg-10 col-lg-offset-1 ' : 'col-lg-6'}} canvas-container">
                    <div class="row">
                        <div class="col-sm-6">
                            <h5>{{$assetType->name}}</h5>
                        </div>
                        <div class="col-sm-6 text-right mb-3 multiple-export-btn">
                            @if(!empty(array_filter($graphData[$assetType->slug], fn($value) => $value !== 0)))
                            <button class="btn btn-primary export-chart-btn"
                                data-name="{{$assetType->name}}"
                                data-filename="asset-created-{{$assetType->slug}}"
                                data-sheettitle="Asset Created - {{$assetType->name}}"
                                data-slug="{{$assetType->slug}}">Export to Excel</button>
                            @endif
                        </div>
                    </div>
                    <div class="chart-wrap">
                        <canvas height="140" id="barChart_{{$assetType->slug}}"></canvas>
                    </div>
                </div>
            @endforeach
        </div>
    </div>
</div>
@endif