<script>
$(document).ready(function(){

    var table = $('.footable').DataTable({
        fixedHeader:true,
		"scrollX": true,
		fixedColumns: true,
		fixedColumns: {
			left: 3
		},
        "processing": true,
        "serverSide": true,
        "ajax":{
            "url": "{{ route('assets-by-department-data') }}",
            "dataType": "json",
            "type": "POST",
            "data": function( result ) {
                result.form = $('#search-form').serializeObject();
            }
        },
        "columns": [
            { "data": "id" },
            { "data": "asset_tag" },
            { "data": "serial_no" },
            { "data": "asset_type" },
            { "data": "make_and_model" },
            { "data": "tech_specs" },
            { "data": "assigned_to" },
            { "data": "original_value" },
            { "data": "depreciated_value" }
        ],
        lengthMenu: [
            [10, 25, 50, 100],
            [10, 25, 50, 100]
        ],
        iDisplayLength: 50,
        columnDefs: [
        { orderable: false, targets: '_all' }
        ],
        "aaSorting": [],
        "fnDrawCallback": function( settings ) {
            $("#department_asset_quantity_span").html(settings.json.recordsTotal);
            $("#department_total_original_value_span").html(settings.json.value.totalOriginalValue);
            $("#department_total_depreciated_value_span").html(settings.json.value.totalDepreciatedValue);

            if (table.page.info().recordsTotal == 0) {
              $("#export-csv").hide();
            } else {
              $("#export-csv").show();
            }
        },
        "bAutoWidth": false,
        "bFilter": true,
        "searching": false,
    });

    $('#search-form').submit(function (e) {
        e.preventDefault();
        table.draw();
    });

    // Data table column toggle
    $('span.col-toggle').on('click', function (e) {
        e.preventDefault();
        $(this).toggleClass('col-hidden');
        // Get the column API object
        var column = table.column($(this).attr('data-column'));

        // Toggle the visibility
        column.visible(!column.visible());
    });

});

$('#export-csv').on('click', function(e) {
    e.preventDefault();
    $('.ajax-loader').show();
    $.ajax({
        type: "POST",
        url: "{{route('assets-by-department-export')}}",
        data: $('#search-form').serializeObject(),
        dataType: 'text',
        success: function(result) {
            var blob = new Blob([result]);
            if (window.navigator.msSaveOrOpenBlob)  // IE hack; see http://msdn.microsoft.com/en-us/library/ie/hh779016.aspx
                window.navigator.msSaveBlob(blob, "assets-by-department-report.csv");
            else
            {
                var a = window.document.createElement("a");
                a.href = window.URL.createObjectURL(blob, {type: "text/plain"});
                a.download = "assets-by-department-report.csv";
                document.body.appendChild(a);
                a.click();  // IE: "Access is denied"; see: https://connect.microsoft.com/IE/feedback/details/797361/ie-10-treats-blob-url-as-cross-origin-and-denies-access
                document.body.removeChild(a);
            }
            $('.ajax-loader').hide();
        }
    })
});


</script>

