@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'Assets By Department', 'parentUrl' => '/report', 'parentTitle' => 'Reports'])
<div class="wrapper-content">
    <div class="container-fluid">
        <div class="ibox">
            <div class="ibox-content">

                <form class="form-horizontal" id="search-form" name="form-report-spend">
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Select Department</label>
                                <select id="departments" name="departments" class="form-control select2">
                                    <option value="">--Select--</option>
                                    @foreach($departments as $dept)
                                    <option value="{{$dept->id}}" @if(request('departments')==$dept->id)
                                        selected="selected" @endif>{{$dept->name}}</option>
                                    @endforeach
                                </select>
                            </div>

                        </div>

                    </div>
                </form>
            </div>
        </div>

        @include('reports.assets-by-department.partials.widget')

        @include('partials.success')
        @include('partials.error-message')
        <div class="ibox">
            <div id="reportView">
                @include('reports.assets-by-department.partials.table')
            </div>
        </div>

    </div>
</div>
@stop

@section('help-links')
@include('help.help-links',['helpLink'=>config('help-links.help_links.user_reports'),'helpTitle'=>config('help-links.help_titles.user_reports')])
@endsection

@section('after_scripts')
@include('reports.script-includes.chartJs')
@include('reports.scripts.common')
@include('reports.scripts.datatable-column-toggle-script');
@include('reports.assets-by-department.scripts.script')
@stop