<script src="/js/plugins/chosen/chosen.jquery.js"></script>
<script>
$(document).ready(function() {
    $('.chosen-select').chosen({width: "100%"}).change(function() {
        $(this).closest('.form-group').next().find('input').focus();
    });

    $(".filter-field").each(function () {
      var name = $(this).attr('key');
      $(this).select2({
        minimumInputLength: 1,
        multiple: true,
        ajax: {
          url: '/get-filter-fields',
          dataType: "json",
          data: function (params) {
            var query = {
              search: params.term,
              type: name
            }

            // Query parameters will be ?search=[term]&type=public
            return query;
          },
          processResults: function (data) {
            // Tranforms the top-level key of the response object from 'items' to 'results'
            return {
              results: data
            };
          },

        }
      });
    });

    var delay = (function(){
        var timer = 0;
        return function(callback, ms){
            clearTimeout (timer);
            timer = setTimeout(callback, ms);
        };
    })();

    $("#search-form select").on('change', function(){
        $('#search-form').submit();
    });

    $("#search-form input").on('keyup', function(){
        $('#search-form').submit();
    });
});
</script>