@extends('layouts.main')
@section('content')

@include('partials.breadcrumb', ['breadcrumbTitle' => 'Assigned Devices', 'parentUrl' => '/report', 'parentTitle' => 'Reports'])
<div class="wrapper-content">

    <div class="container-fluid">
        <div class="row">
            @include('reports.assets-assigned.partials.assets-assigned-filter')
        </div>
        <div class="row">
            <div class="col-lg-12">
                <div class="ibox">
                    <div class="ibox-title">
                        <div class="ibox-tools">
                            <button type="button" id="export-csv" class="btn btn-primary" data-file-name="assets-assigned-report" data-url="{{ route('assigned-devices-export') }}">Export to CSV</button>
                        </div>
                    </div>
                    <div class="ibox-content">
                        @include('partials.success')
                        @include('partials.error-message')
                        <div class="ajax-loader"><img src="/img/ajax-loader-full-width.gif"></div>
                        <div class="dt-coltoggler-wrapper ">
                            <p>Click to toggle table columns: </p>
                        </div>
                        <table class="footable table table-stripped table-hover nowrap three-col-fixed has-column-toggler" data-role="ui-data-table" data-page-size="50" data-url="{{ route('assigned-devices-data') }}" data-searching="false" data-ordering="false" data-scroll-x="false" data-fixed-header="true" data-fixed-header-columns-left="3">
                            <thead>
                                <tr>
                                    <th data-col-name="id">#</th>
                                    <th data-col-name="asset_tag">Asset Tag #</th>
                                    <th data-col-name="serial_no">Serial #</th>
                                    <th data-col-name="asset_type">Asset Type</th>
                                    <th data-col-name="hardware_standard">Hardware Standard</th>
                                    <th data-col-name="tech_specs">Technical Specs</th>
                                    <th data-col-name="asset_status">Asset Status</th>
                                    <th data-col-name="no_of_time_assigned"># of Times Reassigned</th>
                                </tr>
                            </thead>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@stop

@section('after_scripts')
@include('reports.scripts.common')
@include('reports.scripts.datatable')
@include('reports.scripts.filter-options-with-ajax')
@include('reports.scripts.datatable-column-toggle-script');
@include('reports.assets-assigned.scripts.assets-assigned')

@stop