<script src="/js/plugins/morris/raphael-2.1.0.min.js"></script>
<script src="/js/plugins/morris/morris.min.js"></script>

<script>
    $(document).ready(function() {

        var table = $('.assetRecovery').DataTable({
            scrollCollapse: false,
            "processing": true,
            "serverSide": true,
            "ajax": {
                "url": "{{ route('asset-recovery-data') }}",
                "dataType": "json",
                "type": "POST",
                "data": function(result) {
                    result.form = $('#search-form').serializeObject();
                }
            },
            lengthMenu: [
				[10, 25, 50, 100],
            	[10, 25, 50, 100]
			],
			iDisplayLength: 50,
            "columns": [{
                    "data": "id"
                },
                {
                    "data": "asset_tag"
                },
                {
                    "data": "serial_no"
                },
                {
                    "data": "asset_type"
                },
                {
                    "data": "hardware_standard"
                },
                {
                    "data": "tech_specs"
                },
                {
                    "data": "date_it_storage"
                },
                {
                    "data": "old_status"
                },
                {
                    "data": "date_status_changed"
                },
                {
                    "data": "new_status"
                },
                {
                    "data": "depreciated_value"
                }
            ],
            columnDefs: [{
                orderable: false,
                targets: [0, 1]
            }],
            "aaSorting": [],
            "bAutoWidth": false,
            "bFilter": true,
            "searching": false,
            fixedHeader: {
                header: true,
            },
            fixedColumns: true,
			fixedColumns: {
				left: 3
			},
            "scrollX": true,
            fnDrawCallback: function (oSettings) {
                $("#morris-donut-chart").empty();
                Morris.Donut({
                    element: 'morris-donut-chart',
                    data: oSettings.json.value,
                    colors: ['#337ab7', '#f8ac59'],
                    labelColor:"#828282",
                    resize : true,
                });
            }


        });

        // Data table column toggle
        $(document).on('click', 'span.col-toggle', function (e) {
            e.preventDefault();
            $(this).toggleClass('col-hidden');
            // Get the column API object
            var column = table.column($(this).attr('data-column'));

            // Toggle the visibility
            column.visible(!column.visible());
        });

        $('#search-form').submit(function(e) {
            e.preventDefault();
            table.draw();
        });

    });


    $('#export-csv').on('click', function(e) {
        e.preventDefault();
        $('.ajax-loader').show();
        $.ajax({
            type: "POST",
            url: "/report/asset-recovery-data-export",
            data: $('#search-form').serializeObject(),
            dataType: 'text',
            success: function(result) {
                var blob = new Blob([result]);
                var filename = "asset-recovery-report.csv"
                if (window.navigator.msSaveOrOpenBlob) // IE hack; see http://msdn.microsoft.com/en-us/library/ie/hh779016.aspx
                    window.navigator.msSaveBlob(blob, filename);
                else {
                    var a = window.document.createElement("a");
                    a.href = window.URL.createObjectURL(blob, {
                        type: "text/plain"
                    });
                    a.download = filename;
                    document.body.appendChild(a);
                    a.click(); // IE: "Access is denied"; see: https://connect.microsoft.com/IE/feedback/details/797361/ie-10-treats-blob-url-as-cross-origin-and-denies-access
                    document.body.removeChild(a);
                }
                $('.ajax-loader').hide();
            }
        })
    });

</script>