@extends('layouts.main')
@section('content')

@include('partials.breadcrumb', ['breadcrumbTitle' => 'Asset Recovery', 'parentUrl' => '/report', 'parentTitle' => 'Reports'])
<div class="wrapper-content">
    <div class="container-fluid">

        <div class="ibox">
            <div class="ibox-title">
                <div class="ibox-tools">
                    <h5>Filters</h5>
                    <a data-toggle="collapse" href="#collapseFilter" class="collapse-link"> <i class="icon icon-e-delete"></i></a>
                </div>
            </div>
            <div class="collapse in" id="collapseFilter">
                <div class="ibox-content">
                    <form method="post" id="search-form" action="{{ route('asset-recovery-data') }}">
                        {{ csrf_field() }}
                        <div class="row">

                            <div class="col-md-3">
                                <div class="form-group">
                                    <label>Terminated Date Range</label>
                                    <div class="form-group">
                                        <div class="input-group date">
                                            <span class="input-group-addon"><i class="icon icon-calendar-2"></i></span>
                                            <input type="text" name="search_date_from" class="form-control readonly-white" data-mask="99/99/9999" id="date_from" value="{{old('search_date_from')}}" placeholder="From" autocomplete="off" readonly="readonly">
                                        </div>
                                    </div>

                                    <div class="form-group">
                                        <div class="input-group date">
                                            <span class="input-group-addon"><i class="icon icon-calendar-2"></i></span>
                                            <input type="text" name="search_date_to" class="form-control readonly-white" data-mask="99/99/9999" id="date_to" value="{{old('search_date_to')}}" placeholder="To" autocomplete="off"  readonly="readonly">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <div class="ibox">
            <div class="ibox-title">
                <div class="ibox-tools">
                    <h5>Items Returned - Items Redeployed</h5>

                    <a data-toggle="collapse" href="#collapseGraph" class="collapse-link"><i class="icon icon-e-delete"></i></a>
                </div>
            </div>
            <div class="collapse in" id="collapseGraph" aria-expanded="true">
                <div class="ibox-content">
                    <div id="morris-donut-chart"></div>
                </div>
            </div>
        </div>

        <div class="ibox">
            <div class="ibox-title">
                <div class="ibox-tools">
                    <a href="#" id="export-csv" class="btn btn-primary">Export to CSV</a>
                </div>
            </div>
            <div class="ibox-content">
                <div class="ajax-loader"><img src="/img/ajax-loader-full-width.gif"></div>
                <div class="dt-coltoggler-wrapper ">
					<p>Click to toggle table columns: </p>
                </div>
                <div class="table-responsive">
                    <table class="assetRecovery table table-stripped table-hover nowrap three-col-fixed footable has-column-toggler" id="table-report-generator" data-page-length="50" data-searching="false" data-ordering="false">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Asset Tag #</th>
                                <th>Serial # </th>
                                <th>Asset Type</th>
                                <th>Hardware Standard </th>
                                <th>Technical Specs </th>
                                <th>Date On Hand</th>
                                <th>Previous Status</th>
                                <th>Date Deployed</th>
                                <th>Current Status </th>
                                <th>Depreciated Value </th>
                            </tr>
                        </thead>
                        <tbody>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
@stop
@section('after_scripts')
@include('reports.scripts.common')
@include('reports.scripts.datatable-column-toggle-script')
@include('reports.asset-recovery.script.asset-recovery')
@stop