<style>

	th.dtfc-fixed-left {
		background-color: #fff !important;
		z-index: 1000;
	}
	.dtfc-fixed-left {
		background-color: #fff;
	}

	td.dtfc-fixed-left:nth-child(3) {
		border-right: solid 1px #ddd;
	}
</style>
<script>

    $(document).ready(function() {

        var table = $('.footable').DataTable({

            scrollCollapse: false,

            "scrollX": true,
            fixedColumns: true,
            fixedColumns: {
                left: 3
            },
            "processing": true,
            "serverSide": true,
            "ajax":{
                "url": "{{ route('active-users-with-no-asset-data') }}",
                "dataType": "json",
                "type": "POST",
                "data": function( result ) {
                    result.form = $('#search-form').serializeObject();
                }
            },
            "columns": [
                { "data": "id" },
                { "data": "user_name" },
                { "data": "email" },
                { "data": "location" },
                { "data": "manager_name" },
                { "data": "manager_email" },
                { "data": "department" },
                { "data": "start_date" },
                { "data": "status" },
            ],
            lengthMenu: [
				[10, 25, 50, 100],
            	[10, 25, 50, 100]
			],
			iDisplayLength: 50,
            columnDefs: [
               { orderable: false, targets: [0, 1, 2, 3, 4, 5, 6, 7, 8] }
            ],
            "aaSorting": [],
            "bAutoWidth": false,
            "bFilter": true,
            "searching": false,
            fnDrawCallback: function(oSettings) {
                if (oSettings._iRecordsDisplay == 0) {
                    $("#export-user-csv").hide();
                } else {
                    $("#export-user-csv").show();
                }
            }
        });

        // Data table column toggle
		$(document).on('click', 'span.col-toggle', function (e) {
			e.preventDefault();
			$(this).toggleClass('col-hidden');
			// Get the column API object
			var column = table.column($(this).attr('data-column'));

			// Toggle the visibility
			column.visible(!column.visible());
		});

        var delay = (function(){
          var timer = 0;
          return function(callback, ms){
            clearTimeout (timer);
            timer = setTimeout(callback, ms);
          };
        })();


        $("#generalSearchText").on('keyup change', function(){
            delay(function(){
                $('#search-form').submit();
            }, 200 );
        });

        $('#search-form').submit(function (e) {
            e.preventDefault();
            table.draw();
        });

        $('#export-user-csv').on('click', function(e) {
            e.preventDefault();
            $('.ajax-loader').show();
            $.ajax({
                type: "POST",
                url: "/report/user-with-no-asset-export",
                data: $('#search-form').serializeObject(),
                dataType: 'text',
                success: function(result) {
                    var blob = new Blob([result]);
                    if (window.navigator.msSaveOrOpenBlob)  // IE hack; see http://msdn.microsoft.com/en-us/library/ie/hh779016.aspx
                        window.navigator.msSaveBlob(blob, "active-users-with-no-assets.csv");
                    else
                    {
                        var a = window.document.createElement("a");
                        a.href = window.URL.createObjectURL(blob, {type: "text/plain"});
                        a.download = "active-users-with-no-assets.csv";
                        document.body.appendChild(a);
                        a.click();  // IE: "Access is denied"; see: https://connect.microsoft.com/IE/feedback/details/797361/ie-10-treats-blob-url-as-cross-origin-and-denies-access
                        document.body.removeChild(a);
                    }
                    $('.ajax-loader').hide();
                }
            })
        });
    });



</script>