@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'Active Users with No Assets Assigned','parentUrl' =>
'/report', 'parentTitle' => 'Reports'])
<div class="wrapper-content">
    <div class="container-fluid">
        <div class="row">
            @include('reports.active-users-with-no-assets.partials.filters')
        </div>
        <div class="row">
            <div class="col-lg-12">
                <div class="ibox">

                    <div class="ibox-title">
                        <div class="ibox-tools">
                            <a href="#" id="export-user-csv" class="btn btn-primary">Export to CSV</a>
                        </div>
                    </div>

                    <div class="ibox-content">
                        @include('partials.success')
                        @include('partials.error-message')
                        <div class="ajax-loader"><img src="/img/ajax-loader-full-width.gif"></div>
                            <div class="dt-coltoggler-wrapper ">
                                <p>Click to toggle table columns: </p>
                            </div>

                            <table class="footable table table-stripped table-hover nowrap has-column-toggler" data-page-size="50" data-filter=#filter>

                                <thead>

                                    <tr>

                                        <th>#</th>

                                        <th>User</th>

                                        <th>Email</th>

                                        <th>Work Location</th>

                                        <th>Manager Name</th>

                                        <th>Manager Email</th>

                                        <th>Department</th>

                                        <th>Start Date</th>

                                        <th>User Status</th>

                                    </tr>

                                </thead>

                            </table>


                    </div>

                </div>

            </div>

        </div>

    </div>

</div>
@stop

@section('help-links')
@include('help.help-links',['helpLink'=>config('help-links.help_links.user_reports'),'helpTitle'=>config('help-links.help_titles.user_reports')])
@endsection

@section('after_scripts')

@include('reports.scripts.common')
@include('reports.scripts.datatable-column-toggle-script');
@include('reports.active-users-with-no-assets.scripts.script')

@stop

@section('help')
@include('help.users')
@endsection