<div id="sidebar-wrapper" class="active">
<ul class="sidebar-header">
<li>
    <img src="/img/logo.webp" alt="logo" height="25">
</li>
<li>
    <a id="menu-toggle" class="hamburger" href="#">
        <i class="icon icon-menu-8 icon-lg"></i>
    </a>
</li>
</ul>

<ul class="sidebar-nav" id="sidebar">
@can('Dashboard View')
<li>
    <a href="/" data-tooltip="tooltip" data-placement="right" title="Dashboard">
        <i class="icon icon-f-dashboard icon-lg"></i> Dashboard
    </a>
</li>
@endcan

@can('Assets Health View')
    <li @if(count(array_intersect(["permission:Assets Health View"], Route::getCurrentRoute()->middleware()))) class="active"
        @endif>
        <a href="/asset-health" data-tooltip="tooltip" data-placement="right" title="Asset Health">
            <i class="icon icon-bag-50 icon-lg"></i>Asset Health
        </a>
    </li>
@endcan

@can(['IT Assets View'])
<li>
    <a href="/assets" data-tooltip="tooltip" data-placement="right" title="IT Assets">
        <i class="icon icon-laptop-1 icon-lg"></i> IT Assets
    </a>
</li>
@endcan

@can('AV Assets View')
<li><a href="{{ route('av-assets.index') }}" data-tooltip="tooltip" data-placement="right" title="AV Assets">AV Assets</a></li>
@endcan

@can('Mobile Assets View')
<li>
    <a href="{{ route('assets.mobile') }}" data-tooltip="tooltip" data-placement="right" title="Mobile Assets">
        <i class="icon icon-phone-camera-back icon-lg"></i> Mobile Assets</a>
    </li>
    @endcan

    @can('Software Assets View')
    <li>
        <a href="/software-assets" data-tooltip="tooltip" data-placement="right" title="Software Assets">
            <i class="icon icon-window-delete icon-lg"></i>Software Assets
        </a>
    </li>
    @endcan

    @can('Network Assets View')
    <li><a href="/search-network-assets" data-tooltip="tooltip" data-placement="right" title="Network Assets">Network Assets</a></li>
    @endcan

    @can('Cloud Assets View')
    <li @if(in_array(Route::getFacadeRoot()->current()->uri(), ['cloud-assets'])) class="active" @endif>
        <a href="{{ route('cloud-assets.index') }}"><i class="icon icon-laptop-1"></i>Cloud Assets</a>
    </li>
    @endcan

    @can('Accessories View')
    <li>
        <a href="/accessories" data-tooltip="tooltip" data-placement="right" title="Accessories">
            <i class="icon icon-headphones-3 icon-lg"></i>Accessories
        </a>
    </li>
    @endcan

    @can('Research Assets View')
    <li><a href="/research-assets/search" data-tooltip="tooltip" data-placement="right" title="Research Assets">Research Assets</a></li>
    @endcan

    @can('Locations View')
    <li>
        <a href="/location" data-tooltip="tooltip" data-placement="right" title="Locations">
            <i class="icon icon-position-pin icon-lg"></i>Locations
        </a>
    </li>
    @endcan

    @can('People View')
    <li>
        <a href="/users" data-tooltip="tooltip" data-placement="right" title="Users">
            <i class="icon icon-contact-list icon-lg"></i>Users</a>
        </li>
        @endcan

        @can('New Hire')
        <li class="panel">
            <a href="#new-hire-collapse" class="dropdown" data-toggle="collapse" data-parent="#sidebar" data-tooltip="tooltip" data-placement="right" title="New Hire">
                <i class="icon icon-user-create icon-lg"></i> New Hire
                <span class="caret"></span>
            </a>
            <ul class="nav-sidemenu collapse" id="new-hire-collapse">
                <li><a href="/new-hire">New Hire</a></li>
                <li><a href="/new-hire/forecasting">Forecasting</a></li>
                {{-- <li><a href="/new-hire/cost-analysis">Cost Analysis</a></li> --}}
                <li><a href="{{ route('average-deployment-time') }}">Average Deployment Time</a></li>
            </ul>
        </li>
        @endcan

        @can('Terminations')
        <li class="panel">
            <a href="#terminations-collapse" class="dropdown" data-toggle="collapse" data-parent="#sidebar" data-tooltip="tooltip" data-placement="right" title="Terminations">
                <i class="icon icon-user-delete-line icon-lg"></i>Terminations
                <span class="caret"></span>
            </a>
            <ul class="nav-sidemenu collapse" id="terminations-collapse">
                <li><a href="/terms-report">Terminations Report</a></li>
                @can('HR Collections Report')
                <li><a href="{{ route ('collection-statistics') }}">HR Collections Report</a></li>
                @endcan
                @can('Retriever Report')
                {{-- <li><a href="/terminations/retriever-report">Retriever Report</a></li> --}}
                @endcan
            </ul>
        </li>
        @endcan

        @can('Inventory Control View')
        <li class="panel">
            <a href="#inventory-control-collapse" class="dropdown" data-toggle="collapse" data-parent="#sidebar" data-tooltip="tooltip" data-placement="right" title="Inventory Control">
                <i class="icon icon-storage-unit icon-lg"></i>Inventory Control
                <span class="caret"></span>
            </a>
            <ul class="nav-sidemenu collapse" id="inventory-control-collapse">
                <li><a href="/inventory-control/in-stock-computers">In Stock Computers</a></li>
                <li><a href="/inventory-control/available-stock">Available Stock</a></li>
                <li><a href="{{ route('consumption-report.index') }}">Consumption Report</a></li>
                <li><a href="{{ route('users-to-asset-ratio') }}">Users to Asset Ratio</a></li>
                {{-- <li><a href="/inventory-control/on-hand-asset-age">On Hand Asset Age</a></li> --}}
                <li><a href="/inventory-control/fleet-age">Fleet Age</a></li>
                <li><a href="/inventory-control/cycle-count">Cycle Count</a></li>
                @can('ASN - Assets View')
                {{-- <li><a href="/asn-cdw">ASN - CDW</a></li> --}}
                {{-- <li><a href="/asn-connection">ASN - Connection</a></li> --}}
                {{-- <li><a href="/asn-insight">ASN - Insight</a></li> --}}
                <li><a href="/asn-presidio">ASN - Presidio</a></li>
                {{-- <li><a href="/asn-shi">ASN - SHI</a></li> --}}
                {{-- <li><a href="{{ route('revivn-assets.index') }}">Revivn Assets</a></li> --}}
                @endcan
            </ul>
        </li>
        @endcan

        @can('Discovery Tools')
        <li class="panel">

            <a href="#discovery-tools-collapse" class="dropdown" data-toggle="collapse" data-parent="#sidebar" data-tooltip="tooltip" data-placement="right" title="Discovery Tools">
                <i class="icon icon-l-search icon-lg"></i> Discovery Tools
                <span class="caret"></span>
            </a>
            <ul id="discovery-tools-collapse" class="nav-sidemenu collapse">
                {{-- <li><a href="/discovery-tools/workspace-one/all-workspace-one-report">Workspace ONE</a></li> --}}
                {{--  <li><a href="/discovery-tools/chrome-devices/all-chrome-devices-report">Chrome Devices</a></li> --}}
                <li><a href="/discovery-tools/intune/all-report">Intune</a></li>
                {{--  <li><a href="/discovery-tools/jamf/all-report">Jamf</a></li> --}}
                {{-- <li><a href="/discovery-tools/jumpcloud/all-report">JumpCloud</a></li> --}}
                {{-- <li><a href="/discovery-tools/kandji/all-report">Kandji</a></li> --}}
                {{-- <li><a href="/discovery-tools/mobileiron/all-report">MobileIron</a></li> --}}
                <li><a href="/discovery-tools/zoom/all-report">Zoom</a></li>
            </ul>
        </li>
        @endcan
        @can('Security Tools View')
        <li class="panel">

            <a href="#security-collapse" class="dropdown" data-toggle="collapse" data-parent="#sidebar" data-tooltip="tooltip" data-placement="right" title="Security">
                <i class="icon icon-l-security icon-lg"></i> Security
                <span class="caret"></span>
            </a>
            <ul id="security-collapse" class="nav-sidemenu collapse">
                @can('Crowdstrike Reports View')
                <li><a href="/crowdstrike/sensor-detection">Sensor Detection</a></li>
                <li><a href="/crowdstrike/sensor-vulnerabilities">Sensor Vulnerabilities</a></li>
                <li><a href="/crowdstrike/active-cves">Active CVEs</a></li>
                @endcan
            </ul>
        </li>
        @endcan



        @can('Employee Landing Page')
        <li>
            <a href="/my-teq-assets" data-tooltip="tooltip" data-placement="right" title="My TeQ Assets">
                <i class="icon icon-user-check icon-lg"></i>My TeQ Assets
            </a>
        </li>
        @endcan

        @can('Reports View')
        <li>
            <a href="/report" data-tooltip="tooltip" data-placement="right" title="Reports">
                <i class="icon icon-folder-chart-pie icon-lg"></i>Reports
            </a>
        </li>
        @endcan

        @can('Report Generator View')
        <li>
            <a href="/report/generator" data-tooltip="tooltip" data-placement="right" title="Report Generator">
                <i class="icon icon-edit-curves icon-lg"></i>Report Generator
            </a>
        </li>
        @endcan

    </ul>

</div>
