<script src="/js/all.js"></script>

<!-- Fix pace loading issue on firefox */ -->
<script>
    
    if (navigator.platform.indexOf("Win") != -1) {
        var isFirefox = navigator.userAgent.toLowerCase().indexOf('firefox') > -1;
        if (isFirefox) {
            setTimeout(function() {
                let paceElement = document.querySelector(".pace");
                if (paceElement.classList.contains("pace-active")) {
                    // Replace the "my-class" class with the "my-new-class" class
                    paceElement.classList.replace("pace-active", "pace-inactive");
                }
            }, 5000);
        }
    }
    
    
    /**
    * Side menu toggler
    */
    // Check if the state is stored in localStorage and if the state exists, apply it to the toggle button
    var toggleState = localStorage.getItem('menuToggleState');
    
    if (toggleState === 'off') {
        $("#sidebar-wrapper").removeClass('active');
        $("#wrapper").removeClass('menu-on');  
        $(".panel").addClass('menu-off');  
  
    }
    
    // Toggle the class on button click
    $('body').on('click', '#menu-toggle, .menu-off > a', function(e){ 
        e.preventDefault();
        $("#sidebar-wrapper").toggleClass("active");
        $("#wrapper").toggleClass("menu-on");
        $(".panel").toggleClass('menu-off'); 
        $(".nav-sidemenu").removeClass("in");
          

        // Store the state in localStorage
        if ($("#sidebar-wrapper").hasClass('active')) {
            localStorage.setItem('menuToggleState', 'on'); 
        } else {
            localStorage.setItem('menuToggleState', 'off');  
            
        } 
        
    });
    
    
    
    //Side menu toggler end
    
    $('[data-tooltip="tooltip"]').tooltip({
        container: "body"
    });
    
    $("#sidebar-wrapper").on("show.bs.tooltip", function(e) {
        if ($(this).hasClass("active")) {
            return false;
        }
    });
    
    window.themeType = '{!! auth()->user()->theme_preference !!}';
    
    // Change the theme of the website using AJAX.
    function changeTheme(theme) {
        $.ajax({
            type: "POST",
            url: "{{route('switch-theme')}}",
            data: {theme:theme},
            success: function (response) {
                if (response) {
                    if(theme=='dark'){
                        appendCSS('/css/dark.css');
                        $("#change-theme-link").html("<i class='icon icon-moon' style='font-size:16px;''></i><span class='caret'></span>");
                        window.themeType = 'dark';
                    } else {
                        removeCSS('/css/dark.css');
                        $("#change-theme-link").html("<i class='icon icon-sun' style='font-size:16px;'></i><span class='caret'></span>");
                        window.themeType = 'light';
                    }
                } else {
                    // alert("Something went wrong");
                }
            }
        });
    }
    
    // Appends a CSS file to the HTML document by adding a link element to the head section.
    function appendCSS(cssFile) {
        $('head').append('<link href="'+cssFile+'" rel="stylesheet">');
    }
    
    // Removes a CSS file from the document by removing the corresponding link element from the document's head.
    function removeCSS(cssFile) {
        $("link[href='"+cssFile+"']").remove();
    }
    
        var maxHeight = 0;
        $(".row-equal .col").each(function () {
            var thisHeight = $(this).height();
            if (thisHeight > maxHeight) {
                maxHeight = thisHeight;
            }
        });
        $(".row-equal .col").height(maxHeight);
    
</script>