@extends('layouts.main')
@section('content')
	
@include('partials.breadcrumb', ['breadcrumbTitle' => 'Notifications'])
<div class="wrapper-content">

	<div class="container-fluid">
		
		<div class="row">
			@include('notification.filter')
		</div>
		@include('partials.success')
		<div class="ibox">
			<div class="ibox-content">

				<label class="pull-right">Total # of Notifications : {{ $count }}</label>

				<table id="tblNotification" class="footable table table-stripped table-hover" data-page-size="50" data-filter=#filter>

					<thead>

						<tr>
							<th>#</th>
							<th>Notification</th>

						</tr>

					</thead>

					<tbody>			     
						
						@forelse ($notifications as $notification)
						<tr>
							<td>{{ $number++ }}</td>
							<td>{!! $notification['description'] !!}</td>
						</tr>
						
						@empty
						@endforelse
					</tbody>

				</table>

				<div class="pull-right">
				{{ $notifications->appends(['region' => request('region'), 'site_code' => request('site_code'), 'type' => request('type')])->links() }}
				</div>
			
			</div>

		</div>
	</div>

</div>

@stop

@section('after_scripts')
<link href="/css/plugins/dataTables/fixedHeader.dataTables.min.css" rel="stylesheet">
<script src="/js/plugins/chosen/chosen.jquery.js"></script>
<script src="/js/plugins/chosen/chosen.ajaxaddition.jquery.js"></script>
<script type="text/javascript">

	$(document).ready(function() {
	
		$('.chosen-select').chosen({width: "100%"});

	});

</script>

@stop