<script src="/js/plugins/chosen/chosen.jquery.js"></script>
<script src="/js/plugins/chosen/chosen.ajaxaddition.jquery.js"></script>
<script src="/js/plugins/dataTables/datatables.min.js"></script>
<script src="/js/plugins/dataTables/dataTables.fixedColumns.min.js"></script>
<link href="/css/plugins/dataTables/fixedHeader.dataTables.min.css" rel="stylesheet">
<script>

    $(document).ready(function () {
        $('.chosen-select').chosen({ width: "100%" }).change(function () {
            $(this).closest('.form-group').next().find('input').focus();
        });

        $.fn.serializeObject = function () {
            var obj = {};

            $.each(this.serializeArray(), function (i, o) {
                var n = o.name, v = o.value;

                obj[n] = obj[n] === undefined ? v
                    : $.isArray(obj[n]) ? obj[n].concat(v)
                        : [obj[n], v];
            });

            return obj;
        };

        var table = $('.footable').DataTable({
            fixedHeader:true,
			"scrollX": true,
			fixedColumns: true,
			fixedColumns: {
				left: 3
			},
            scrollY: '400px',
            scrollCollapse: true,
            "processing": true,
            "serverSide": true,
            "ajax": {
                "url": "{{ route('location-data') }}",
                "dataType": "json",
                "type": "POST",
                "data": function (result) {
                    result.form = $('#search-form').serializeObject();
                }
            },
            "columns": [
                { "data": "id" },
                { "data": "site_code" },
                { "data": "type" },
                { "data": "room_name" },
                { "data": "address" },
                { "data": "floor" },
                { "data": "building" },
                { "data": "country" },
                { "data": "region" },
                { "data": "vc" },
                { "data": "capacity" },
                { "data": "zoom" },
                { "data": "status" },
                { "data": "of_assets" },
                { "data": "action" },
            ],
            lengthMenu: [
                [50, 100, 200],
                ['50', '100', '200']
            ],
            columnDefs: [
                { orderable: false, targets: '_all' }
            ],
            "aaSorting": [],
            "dom": '<"top"i>rt<"bottom"flp><"clear">',
            "bAutoWidth": false,
            "bFilter": true,
            "bLengthChange": false,
            "searching": false,
            "fnDrawCallback": function (oSettings) {
            if (table.page.info().recordsTotal == 0) {
                $("#export-csv").hide();
            } else {
                $("#export-csv").show();
            }
        },

        });

        var delay = (function () {
            var timer = 0;
            return function (callback, ms) {
                clearTimeout(timer);
                timer = setTimeout(callback, ms);
            };
        })();

        $('#search-form').submit(function (e) {
            e.preventDefault();
            table.draw();
        });

        $("#location_type").on('change', function () {
            $('#search-form').submit();
        });

        $("#searchText").on('keyup change', function () {
            delay(function () {
                $('#search-form').submit();
            }, 200);
        });

        $("#have_assets").on('change', function () {
            if ($("#have_assets").val() == 2) {
                $('#countDiv').hide();
                $('#no_of_assets').val('');
            } else if ($("#have_assets").val() == 1) {
                $('#countDiv').show();
            }

            $('#search-form').submit();
        });

        $('#no_of_assets').on('keyup change', function () {
            $('#search-form').submit();
        });

        $("#status").on('change', function () {
            $('#search-form').submit();
        });

        $("#floor").on('change', function () {
            $('#search-form').submit();
        });

        $("#country").on('change', function () {
            $('#search-form').submit();
        });

        $("#region").on('change', function () {
            $('#search-form').submit();
        });

        $("#vc").on('change', function () {
            $('#search-form').submit();
        });

        $(".form-select-field").on('change', function () {
            $('#search-form').submit();
        });


        $('#export-csv').on('click', function (e) {
            e.preventDefault();
            $('.ajax-loader').show();
            $.ajax({
                type: "POST",
                url: "/location/location-export",
                data: $('#search-form').serializeObject(),
                dataType: 'text',
                success: function (result) {
                    var checkPortion = 'Your report will be generated in the background.';
					if (checkPortion == result.substring(0, 48)) {
						$("#sync-success-msg").html(result);
            			$("#sync-success").show();
						$('.ajax-loader').hide();
					} else {
                        var blob = new Blob([result]);
                        if (window.navigator.msSaveOrOpenBlob)  // IE hack; see http://msdn.microsoft.com/en-us/library/ie/hh779016.aspx
                            window.navigator.msSaveBlob(blob, "locations.csv");
                        else {
                            var a = window.document.createElement("a");
                            a.href = window.URL.createObjectURL(blob, { type: "text/plain" });
                            a.download = "locations.csv";
                            document.body.appendChild(a);
                            a.click();  // IE: "Access is denied"; see: https://connect.microsoft.com/IE/feedback/details/797361/ie-10-treats-blob-url-as-cross-origin-and-denies-access
                            document.body.removeChild(a);
                        }
                        $('.ajax-loader').hide();
                    }
                }
            })
        });

    });

</script>