<script src="/js/plugins/match-height/jquery.matchHeight.min.js"></script>
<script>

    $(document).ready(function () {
        $('.match-height-block').matchHeight({ property: 'height' });
        $('.chosen-select').chosen({ width: "100%" }).change(function () {
            $(this).closest('.form-group').next().find('input').focus();
        });

        var tableAsset = $('.footable2').DataTable({
            responsive: true,
            scrollCollapse: false,
            scrollX: false,
            scrollY: false,
            "processing": true,
            "serverSide": true,
            paging: true,
            "pageLength": 25,
            lengthMenu: [
                [25, 50, 100, 200],
                ['25', '50', '100', '200']
            ],
            columnDefs: [
                { orderable: false, targets: [0, 1, 2, 3, 4, 5, 6, 7] }
            ],
            "aaSorting": [],
            "dom": '<"top"i>rt<"bottom"flp><"clear">',
            "bAutoWidth": true,
            "bFilter": true,
            "bLengthChange": false,
            "searching": false,
            fixedHeader: {
                header: true,
            },
            "ajax": {
                "url": "{{ route('location-asset-data') }}",
                "dataType": "json",
                "type": "POST",
                data: function (result) {
                    result.form = $('#search-form').serializeObject();
                }
            },
            "columns": [
                { "data": "id" },
                { "data": "asset_type" },
                { "data": "hardware" },
                { "data": "technical_spec" },
                { "data": "asset_tag" },
                { "data": "serial_no" },
                { "data": "status" },
                { "data": "age" },
            ]


        });

        var tableAccessory = $('.footable3').DataTable({
            responsive: true,
            scrollCollapse: false,
            scrollX: false,
            scrollY: false,
            "processing": true,
            "serverSide": true,
            paging: true,
            "pageLength": 25,
            lengthMenu: [
                [25, 50, 100, 200],
                ['25', '50', '100', '200']
            ],
            columnDefs: [
                { orderable: false, targets: [0, 1, 2] }
            ],
            "aaSorting": [],
            "dom": '<"top"i>rt<"bottom"flp><"clear">',
            "bAutoWidth": true,
            "bFilter": true,
            "bLengthChange": false,
            "searching": false,
            fixedHeader: {
                header: true,
            },
            "ajax": {
                "url": "{{ route('location-accessories-data') }}",
                "dataType": "json",
                "type": "POST",
                data: function (result) {
                    result.form = $('#accessory-search-form').serializeObject();
                }
            },
            "columns": [
                { "data": "id" },
                { "data": "hardware" },
                { "data": "technical_spec" },
            ]


        });

        var delay = (function () {
            var timer = 0;
            return function (callback, ms) {
                clearTimeout(timer);
                timer = setTimeout(callback, ms);
            };
        })();

        $('#filter').on('keyup change', function (e) {
            delay(function () {
                $('#search-form').submit();
            }, 200);
        });

        $('#search-form').submit(function (e) {
            e.preventDefault();
            tableAsset.draw();
        });

        $('#filterAccessory').on('keyup change', function (e) {
            delay(function () {
                $('#accessory-search-form').submit();
            }, 200);
        });

        $('#accessory-search-form').submit(function (e) {
            e.preventDefault();
            tableAccessory.draw();
        });

        //Datatable column toggler
        $('span.col-toggle').on('click', function (e) {
            e.preventDefault();
            $(this).toggleClass('col-hidden');
            // Get the column API object
            var column = table.column($(this).attr('data-column'));

            // Toggle the visibility
            column.visible(!column.visible());
        });

        var locationId = $('#locationId').val();
        if (locationId) {
            $.ajax({
                url: "/location-detail-asset-value/" + locationId,
                "type": "POST",
                success: function (data) {
                    $('.locationSum').html('Value of Assets : $ ' + data);
                },
                error: function (xhr, ajaxOptions, thrownError) {
                }
            });
        }

        var tableZoomAssets = $('#zoom-assets').DataTable({
            responsive: true,
            scrollCollapse: false,
            scrollX: false,
            scrollY: false,
            "processing": true,
            "serverSide": true,
            paging: true,
            "pageLength": 25,
            "aaSorting": [],
            "dom": '<"top"i>rt<"bottom"flp><"clear">',
            "bAutoWidth": true,
            "bFilter": true,
            "bLengthChange": false,
            "searching": false,
            fixedHeader: {
                header: true,
            },
            "ajax": {
                "url": "{{ route('location-zoom-data') }}",
                "dataType": "json",
                "type": "POST",
                data: function (result) {
                    result.form = $('#zoom-assets-form').serializeObject();
                }
            },
            "columns": [
                { "data": "id" },
                { "data": "serial_no" },
                { "data": "checkbox" },
            ]
        });

        $('#zoom-filter').on('keyup', function (e) {
            delay(function () {
                $('#zoom-assets-form').submit();
            }, 200);
        });

        $('body').on('submit', '#zoom-assets-form', function(e) {
            e.preventDefault();
            tableZoomAssets.draw();
        });
    });

</script>