	<div class="ibox">
		<div class="ibox-title">
			<div class="ibox-tools">
				<h5>Filters</h5>
				<a data-toggle="collapse" href="#collapseFilter" class="collapse-link"> <i class="icon icon-e-delete"></i></a>
			</div>
		</div>
		<div class="collapse in" id="collapseFilter">
			<div class="ibox-content">
				<form method="post" id="search-form" action="">
					{{ csrf_field() }}
					<div class="row">
						<div class="col-md-3 divHeight">
							<div class="form-group">
								<label class="control-label">Location Type</label>
								<select class="chosen-select" id="location_type" multiple name="location_type" data-placeholder="Select">
									@foreach(\App\Models\LocationType::orderBy('location_type_name')->get() as $type)
									<option value="{{$type->id}}">{{$type->location_type_name}}</option>
									@endforeach
								</select>
							</div>
						</div>

						<div class="col-md-3 divHeight">
							<div class="form-group">
								<label class="control-label">Search</label>
								<input type="text" class="form-control" name="searchText" id="searchText" placeholder="Search by Name/Address/Building/Floor" autocomplete="off">
							</div>
						</div>

						<div class="col-md-3 divHeight">
							<div class="form-group">
								<label class="control-label">Have Assets</label>
								<select class="chosen-select" name="have_assets" id="have_assets" data-placeholder="Select">
									<option value="select">Select</option>
									<option value="1">Yes</option>
									<option value="2">No</option>
								</select>
							</div>
						</div>

						<div class="col-md-3 divHeight" id="countDiv">
							<div class="form-group">
								<label class="control-label">No of Assets</label>
								<input type="number" class="form-control" name="no_of_assets" id="no_of_assets" autocomplete="off">
							</div>
						</div>

						<div class="col-md-3 divHeight">
							<div class="form-group">
								<label class="control-label">Status</label>
								<select class="chosen-select" name="status" id="status" data-placeholder="Select">
									<option value="select">Select</option>
									<option value="1">Active</option>
									<option value="2">Inactive</option>
								</select>
							</div>
						</div>

						<div class="col-md-3 divHeight">
							<div class="form-group">
								<label class="control-label">Country</label>
								<select class="chosen-select" id="country" multiple name="country" data-placeholder="Select">
									@foreach(\App\Models\Country::orderBy('name')->get() as $country)
									<option value="{{$country->id}}">{{$country->name}}</option>
									@endforeach
								</select>
							</div>
						</div>

						<div class="col-md-3 divHeight">
							<div class="form-group">
								<label class="control-label">Region</label>
								<select class="chosen-select" id="region" multiple name="region" data-placeholder="Select">
									@foreach(\App\Models\Region::orderBy('name')->get() as $region)
									<option value="{{$region->id}}">{{$region->name}}</option>
									@endforeach
								</select>
							</div>
						</div>

						<div class="col-md-3 divHeight">
							<div class="form-group">
								<label class="control-label">VC</label>
								<select class="chosen-select" name="vc" id="vc" data-placeholder="Select">
									<option value="select">Select</option>
									<option value="1">Yes</option>
									<option value="2">No</option>
								</select>
							</div>
						</div>

						<div class="col-sm-3 divHeight">
							<div class="form-group">
								<label class="control-label">Zoom</label>
								<select class="chosen-select form-select-field" name="zoom" id="zoom" data-placeholder="Select">
									<option value="select">Select</option>
									<option value="1">Yes</option>
									<option value="2">No</option>
								</select>
							</div>
						</div>

					</div>
				</form>
			</div>
		</div>
	</div>