@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'Locations'])
@include('file-exports.partials.file-exports-submenu',['report_type' => 'location_report'])
<div class="wrapper-content">

    <div class="container-fluid">

        @include('location.partials.filters')

        <div class="ibox">

            <div class="ibox-content">

                <div class="ibox-tools m-b-sm">

                    @can('Locations Create')
                    <a href="{{route('location.create')}}" class="btn btn-primary pull-right">Add New Location</a>
                    @endcan

                    <a href="#" id="export-csv" class="btn btn-primary">Export to CSV</a>

                </div>


                @include('partials.success')
                @include('partials.error-message')
                @include('partials.sync-messages')
                <div class="ajax-loader"><img src="/img/ajax-loader-full-width.gif"></div>
                <table class="footable table table-stripped table-hover nowrap three-col-fixed" data-page-size="50" data-filter=#filter>

                    <thead>

                        <tr>

                            <th>#</th>

                            <th>Site Code</th>

                            <th>Type</th>

                            <th>Name</th>

                            <th>Address</th>

                            <th>Floor #</th>

                            <th>Building</th>

                            <th>Country</th>

                            <th>Region</th>

                            <th>VC</th>

                            <th>#</th>

                            <th>Zoom</th>

                            <th>Status</th>

                            <th># of Assets</th>

                            <th></th>

                        </tr>

                    </thead>

                    <tbody>

                    </tbody>

                </table>

            </div>

        </div>

    </div>

</div>
@stop

@section('help-links')
@include('help.help-links',['helpLink'=>config('help-links.help_links.locations'),'helpTitle'=>config('help-links.help_titles.locations')])
@endsection

@section('after_scripts')

@include('location.script')

@stop
