@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'Edit Location', 'parentUrl' => '/location', 'parentTitle' => 'Locations'])

<div class="wrapper-content">
    <div class="container-fluid">
		<div class="ibox">
    	<form class="form-horizontal" method="post" action="{{route('location.update', ['location' => $location->id])}}">
    		{{csrf_field()}}
    		<input type="hidden" name="_method" value="PUT">
	        <div class="row">
	        	@include('partials.error')
	        	@include('partials.error-message')

				@if ($location->manually_created == 0)
	            <div class="col-lg-6">

	            	<div class="ibox-content">

	                    <div class="form-group">
	                        <label class="col-lg-3 control-label">Room Name</label>
	                        <div class="col-lg-9">
	                            <input type="text" class="form-control" name="room_name" value="{{$location->room_name}}" readonly="">
	                        </div>
	                    </div>

	          			<div class="form-group">

							<label class="col-lg-3 control-label">Room Type</label>

							<div class="col-lg-9">

								@include('partials.dropdowns.room-type', ['selected_id' => $location->location_type_id])

							</div>

						</div>

	                    <div class="form-group">
	                        <label class="col-lg-3 control-label">Status</label>
	                        <div class="col-lg-9">
	                            @include('partials.dropdowns.status', ['selected_id' => $location->status])
	                        </div>
	                    </div>

	                    <div class="form-group">
							<div class="col-lg-offset-3 col-lg-9">
								<button class="btn btn-primary" type="submit" name="commit">Save</button>
							</div>
						</div>

		            </div>
		        </div>
				@elseif ($location->manually_created == 1)
				<div class="col-lg-6">
	            	<div class="ibox-content">
	          			<div class="form-group">
							<label class="col-lg-3 control-label">Room Type</label>
							<div class="col-lg-9">
								@include('partials.dropdowns.room-type', ['selected_id' => $location->location_type_id])
							</div>
						</div>
						<div class="form-group">
							<label class="col-lg-3 control-label">Site Code</label>
							<div class="col-lg-9">
								@include('partials.dropdowns.site-code', ['selected_id' => $location->site_code_id])
							</div>
						</div>
						<div class="form-group">
							<label class="col-lg-3 control-label">Address</label>
							<div class="col-lg-9">
								<input type="text" class="form-control" name="address"  value="{{$location->address}}">
							</div>
						</div>
						<div class="form-group disable-div disable-onselect">
							<label class="col-lg-3 control-label">Country</label>
							<div class="col-lg-9">
								@include('partials.dropdowns.country-locations', ['selected_id' => optional($location->siteCode)->country_id])
							</div>
						</div>
	                    <div class="form-group">
	                        <label class="col-lg-3 control-label">Status</label>
	                        <div class="col-lg-9">
	                            @include('partials.dropdowns.status', ['selected_id' => $location->status])
	                        </div>
	                    </div>
	                    <div class="form-group">
							<div class="col-lg-offset-3 col-lg-9">
								<button class="btn btn-primary" type="submit" name="commit">Save</button>
							</div>
						</div>
		            </div>
		        </div>

		        <div class="col-lg-6">
		        	<div class="ibox-content">
		        		<div class="form-group">
	                        <label class="col-lg-3 control-label">Room Name</label>
	                        <div class="col-lg-9">
	                            <input type="text" class="form-control" name="room_name" value="{{$location->room_name}}">
	                        </div>
	                    </div>
	                    <div class="form-group">
							<label class="col-lg-3 control-label">Building</label>
							<div class="col-lg-9">
								<input type="text" class="form-control" name="building" value="{{$location->building}}">
							</div>
						</div>
						<div class="form-group">
							<label class="col-lg-3 control-label">Floor #</label>
							<div class="col-lg-9">
								@include('partials.dropdowns.floor', ['selected_id' => $location->floor])
							</div>
						</div>
						<div class="form-group disable-div disable-onselect">
							<label class="col-lg-3 control-label">Region</label>
							<div class="col-lg-9">
								@include('partials.dropdowns.region-locations', ['selected_id' => optional($location->siteCode)->region_id])
							</div>
						</div>
		        	</div>
		        </div>
				@endif
		    </div>
		</form>
	</div>
        <div class="ibox">
	        <div class="ibox-title">
	            <h3>Assets in Location ({{$location->assets_count ? $location->assets_count : 0}} assets)</h3>
	        </div>
	        <div class="ibox-content">
	            @include('location.assets-in-location')
	        </div>
	    </div>

	</div>
</div>
@stop

@section('help-links')
@include('help.help-links',['helpLink'=>config('help-links.help_links.locations'),'helpTitle'=>config('help-links.help_titles.locations')])
@endsection

@section('after_scripts')
    @include('assets.partials.scripts.common')
	@include('reports.scripts.common')
	@include('reports.scripts.datatable')
	@include('location.partials.scripts.detail-script')
    <script>


    	$("#site_code_id").on('change', function () {
			var siteCode = this.value;
			$.ajax({
			    type: "POST",
			    url: "/location/site-code",
			    data: {siteCode : siteCode} ,
			    success: function(data) {
			    	$('#country_id').select2('val', data.country_id);
			    	$('.disable-div').addClass('disable-onselect');
			    	$('#region_id').select2('val', data.region_id);
			    },
			});
		});

    </script>
@stop
