@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'Location Detail', 'parentUrl' => '/location', 'parentTitle' =>
'Locations'])

<div class="wrapper-content">

    <div class="container-fluid">
        @if($location)
        <div class="row">
            <input type="hidden" name="locationId" value="{{$location->id}}" id="locationId">

            <div class="col-lg-6">

                <div class="ibox">

                    <div class="ibox-content match-height-block">

                        <dl class="dl-horizontal">

                            <dt>Room Name</dt>

                            <dd>{{$location->room_name}}</dd>

                            <dt>Room Type</dt>

                            <dd>{{optional($location->locationType)->location_type_name}}</dd>

                            <dt>Resource Type</dt>

                            <dd>{{optional($location->resourceType)->name}}</dd>

                            <dt>Status</dt>

                            <dd>{{$location->status == 1 ? 'Active' : 'Inactive' }}</dd>

                        </dl>

                    </div>

                </div>

            </div>

            <div class="col-lg-6">

                <div class="ibox">

                    <div class="ibox-content match-height-block">

                        <dl class="dl-horizontal">


                            <dt>Address</dt>

                            <dd>{{$location->address}}</dd>

                            <dt>Floor</dt>

                            <dd>{{$location->floor}}</dd>

                            <dt>Room Capacity</dt>

                            <dd>{{$location->room_capacity}}</dd>

                            <dt>Country</dt>
                            <dd>{{ optional($location->country)->name }}</dd>

                            <dt>State</dt>
                            <dd>{{ optional($location->state)->name }}</dd>

                            <dt>City</dt>
                            <dd>{{ $location->city }}</dd>

                            <dt>Zip</dt>
                            <dd>{{ $location->zip }}</dd>

                            <dt>Region</dt>
                            <dd>{{ optional($location->region)->name }}</dd>

                            <dt>Site Code</dt>
                            <dd>{{ optional($location->siteCode)->code }}</dd>

                            <dt>Airplay</dt>
                            <dd>{{ ($location->air_play == 1) ? 'Yes': 'No'}}</dd>

                            <dt>TV</dt>
                            <dd>{{ ($location->tv == 1) ? 'Yes': 'No' }}</dd>

                            <dt>Zoom Room</dt>
                            <dd>{{ ($location->zoom == "Zoom") ? 'Yes': 'No' }}</dd>

                        </dl>

                    </div>

                </div>

            </div>

        </div>

        <div class="ibox">
            <div class="ibox-title">
                <div class="row">
                    <div class="col-md-6">
                        <h3>Assets in Location ({{$location->assets_count ? $location->assets_count : 0}} assets)</h3>
                    </div>
                    <div class="col-md-6">
                        <h4 class="pull-right locationSum">Value of Assets : $ 0</h4>
                    </div>
                </div>
            </div>
            <div class="ibox-content">
                @include('location.assets-in-location')
            </div>
        </div>
        <div class="ibox">
            <div class="ibox-title">
                <div class="row">
                    <div class="col-md-6">
                        <h3>Accessories in Location ({{$location->accessories_count ? $location->accessories_count : 0}}
                            accessories)</h3>
                    </div>
                    <div class="col-md-6">
                        {{-- <h4 class="pull-right">Value of Accessories : }}</h4> --}}
                    </div>
                </div>
            </div>
            <div class="ibox-content">
                @include('location.accessories-in-location')
            </div>
        </div>

        <div class="ibox float-e-margins">
            <div class="ibox-title">
                <div class="row">
                    <div class="col-md-6">
                        <h3>Zoom Devices in Location ({{$location->zoom_devices_count ?: 0}} devices)</h3>
                    </div>
                </div>
            </div>
            <div class="ibox-content">
                @include('location.zoom-assets-in-location')
            </div>
        </div>

        @include('location.location-history')

        @else
        <div class="row">
            <div class="col-sm-12">
                <h2>Location Not Found</h2>
            </div>
        </div>

        @endif

    </div>
</div>
@stop

@section('help-links')
@include('help.help-links',['helpLink'=>config('help-links.help_links.locations'),'helpTitle'=>config('help-links.help_titles.locations')])
@endsection

@section('after_scripts')
@include('assets.partials.scripts.common')
@include('reports.scripts.common')
@include('reports.scripts.datatable')
@include('location.partials.scripts.detail-script')
@stop
