@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'Create Location', 'parentUrl' => '/location', 'parentTitle' =>
'Locations'])

<div class="wrapper-content">

	<div class="container-fluid">

		<div class="row">
		@include('partials.error')
		@include('partials.error-message')

			<div class="col-lg-12">

				<div class="ibox">

					<div class="ibox-content">

						<form class="form-horizontal" method="post" action="{{route('location.store')}}">
							{{csrf_field()}}
							<div class="row">
								<div class="col-lg-6">
									<div class="form-group">

										<label class="col-lg-4 control-label">Room Type</label>

										<div class="col-lg-8">

											@include('partials.dropdowns.room-type')

										</div>

									</div>
								</div>
								<div class="col-lg-6">
									<div class="form-group">

										<label class="col-lg-4 control-label">Room Name</label>

										<div class="col-lg-8">

											<input type="text" class="form-control" name="room_name"  value="{{old('room_name')}}">

										</div>

									</div>
								</div>
							</div>



							<div class="row">
								<div class="col-lg-6">
									<div class="form-group">

										<label class="col-lg-4 control-label">Site Code</label>

										<div class="col-lg-8">

											@include('partials.dropdowns.site-code')

										</div>

									</div>
								</div>
								<div class="col-lg-6">
									<div class="form-group">

										<label class="col-lg-4 control-label">Building</label>

										<div class="col-lg-8">

											<input type="text" class="form-control" name="building" value="{{old('building')}}">

										</div>

									</div>
								</div>
							</div>
							<div class="row">
								<div class="col-lg-6">
									<div class="form-group">

										<label class="col-lg-4 control-label">Address</label>

										<div class="col-lg-8">

											<input type="text" class="form-control" name="address"  value="{{old('address')}}">

										</div>

									</div>
								</div>
								<div class="col-lg-6">
									<div class="form-group">

										<label class="col-lg-4 control-label">Floor #</label>

										<div class="col-lg-8">

											@include('partials.dropdowns.floor')

										</div>

									</div>
								</div>
							</div>

							<div class="row">
								<div class="col-lg-6" >
									<div class="form-group disable-div">

										<label class="col-lg-4 control-label">Country</label>

										<div class="col-lg-8">

											@include('partials.dropdowns.country-locations')

										</div>

									</div>
								</div>
								<div class="col-lg-6">
									<div class="form-group disable-div">

										<label class="col-lg-4 control-label">Region</label>

										<div class="col-lg-8">

											@include('partials.dropdowns.region-locations')

										</div>

									</div>
								</div>
							</div>

							<div class="row">

								<div class="col-lg-6">

									<div class="form-group">

										<label class="col-lg-4 control-label">Status</label>

										<div class="col-lg-8">

											@include('partials.dropdowns.status')

										</div>

									</div>

								</div>

							</div>

							<div class="form-group">

								<div class="col-lg-offset-2 col-lg-10">

									<button class="btn btn-primary pull-right" type="submit" name="save">Save</button>

								</div>

							</div>

						</form>

					</div>

				</div>

			</div>

		</div>

	</div>

</div>
@stop

@section('help-links')
@include('help.help-links',['helpLink'=>config('help-links.help_links.create_locations'),'helpTitle'=>config('help-links.help_titles.create_locations')])
@endsection

@section('after_scripts')
<script>

	$(document).ready(function(){


		$(".select2").select2();

		$("#site_code_id").on('change', function () {
			var siteCode = this.value;
			$.ajax({
			    type: "POST",
			    url: "/location/site-code",
			    data: {siteCode : siteCode} ,
			    success: function(data) {
			    	$('#country_id').select2('val', data.country_id);
			    	$('.disable-div').addClass('disable-onselect');
			    	$('#region_id').select2('val', data.region_id);
			    },
			});
		});


		formmodified=0;
	    $('form *').change(function(){
	        formmodified=1;
	    });
	    window.onbeforeunload = confirmExit;
	    function confirmExit() {
	        if (formmodified == 1) {
	            return "New information not saved. Do you wish to leave the page?";
	        }
	    }
	    $("button[name='save']").click(function() {
	        formmodified = 0;
	    });

	});

</script>
@stop