<script src="/js/plugins/dataTables/datatables.min.js"></script>
<link href="/css/plugins/dataTables/fixedHeader.dataTables.min.css" rel="stylesheet">
<link rel="stylesheet" href="/css/plugins/dataTables/responsive.dataTables.min.css">
<script src="/js/plugins/dataTables/dataTables.responsive.min.js"></script>
<script src="/js/sweetalert2.all.min.js"></script>
<script>
    $(document).ready(function () {


        var table = $('.report-table').DataTable({
            responsive: true,
            scrollCollapse: false,
            scrollX: false,
            scrollY: false,
            "processing": true,
            paging: true,
            "pageLength": 10,
            lengthMenu: [
                [50, 100, 200],
                ['50', '100', '200']
            ],
            columnDefs: [
                { orderable: false, targets: ['_all'] },
            ],
            "aaSorting": [],
            "dom": '<"top"i>rt<"bottom"flp><"clear">',
            "bAutoWidth": true,
            "bFilter": true,
            "bLengthChange": false,
            "searching": false,
            fixedHeader: {
                header: true,
            }
        });

        $('.mark-download').on('click', function (e) {
            e.preventDefault();
            Swal.fire({
                title: "Are you sure to remove the report? ",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                confirmButtonText: 'Ok'
            }).then((result) => {
                if (result.isConfirmed) {
                    var reportId = $(this).data("id");
                    $('.ajax-loader').show();
                    $(".sync-msg").hide();
                    $.ajax({
                        type: "get",
                        url: "/generated-exports-downloaded/" + reportId,
                        success: function (result) {
                            // $('.report-row-' + reportId).remove();
                            // table.draw();
                            // $('.ajax-loader').hide();
                            // $('#sync-success').show();
                            // $('#sync-success-msg').text("Report removed successfully.");
                            if (response.success) {
                                location.reload();
                            } else {
                                $('#sync-error-msg').text(response.message);
                                $('#sync-error').show();
                            }
                        }
                    })
                }
            })

        });

    });



</script>