@extends('layouts.main')
@section('content')

@php
$reportName = '';
$parentUrl = '';

$currentUrl = request()->url();

$segments = collect(explode('/', url($currentUrl)))->filter();
$lastSegment = $segments->last();

$reportName = config('file-exports.' . $lastSegment . '.parent_title') ?? '';
$parentUrl = config('file-exports.' . $lastSegment . '.parent_url') ?? '';

@endphp


@include('partials.breadcrumb', ['breadcrumbTitle' => 'Generated Reports', 'parentUrl' =>$parentUrl,
'parentTitle' => $reportName ])
@include('file-exports.partials.file-exports-submenu',['report_type' => $reportType])

<div class="wrapper-content">

    <div class="container-fluid">

        <div class="row">

            <div class="col-lg-12">

                <div class="ibox">

                    <div class="ibox-content">
                        @include('partials.success')
                        @include('partials.error-message')
                        @include('partials.sync-messages')

                        <table class="report-table table table-stripped table-hover" data-page-size="10" data-filter=#filter>

                            <thead>

                                <tr>

                                    <th>Date</th>
                                    <th>Time (PST)</th>
                                    <th>Status</th>
                                    <th>Download</th>
                                    <th>Delete</th>

                                </tr>

                            </thead>

                            <tbody>

                                @foreach($generatedExportsList as $report)

                                <tr class="report-row-{{$report->id}}">

                                    <td>{{parse_date_from_db_datetime($report->created_at)}} </td>

                                    <td>@if($report->report_url != null){{parse_time_from_db_datetime($report->updated_at)}}
                                        @endif</td>

                                    <td>@if($report->report_url != null) Completed @else Processing @endif</td>

                                    <td>@if($report->report_url != null)<a
                                            href="/storage/export_reports/{{$report->report_url}}">{{$report->report_url}}</a>
                                        @endif</td>

                                    <td>@if($report->report_url != null)
                                        <a href="" data-id="{{$report->id}}"
                                            class="mark-download" data-toggle="tooltip" data-placement="top"
                                            title="Mark As Downloaded And Delete"><i class="icon icon-delete-forever"></i></a>
                                        @endif
                                    </td>

                                </tr>

                                @endforeach


                            </tbody>

                            <tfoot>

                                <tr>

                                    <td colspan="5">

                                        <ul class="pagination pull-right"></ul>

                                    </td>

                                </tr>

                            </tfoot>

                        </table>

                    </div>

                </div>

            </div>

        </div>

    </div>
    @stop


    @section('after_scripts')
    @include('file-exports.scripts.file-export-scripts')
    @stop