<script src="/js/plugins/dataTables/datatables.min.js"></script>
<script src="/js/plugins/dataTables/dataTables.fixedHeader.min.js"></script>
<link href="/css/plugins/dataTables/fixedHeader.dataTables.min.css" rel="stylesheet">
<link rel="stylesheet" href="/css/plugins/dataTables/responsive.dataTables.min.css">
<script src="/js/plugins/dataTables/dataTables.responsive.min.js"></script>
<script src="/js/plugins/match-height/jquery.matchHeight.min.js"></script>

<script>
$(document).ready(function() {
    $('.match-height-block').matchHeight({ property: 'height' });
    var table1 = $('.dataTable-panel-active').DataTable({
        // responsive: true,
        scrollCollapse: false,
        // scrollX: false,
        // scrollY: false,
        "processing": true,
        "serverSide": true,
        "ajax":{
            "url": "{{ route('employees-active-data') }}",
            "dataType": "json",
            "type": "POST",
            "data": {"status" : "active"}
        },
        "columns": [
            { "data": "details" },
            { "data": "id" },
            { "data": "first_name" },
            { "data": "last_name" },
            { "data": "hire_date" },
            { "data": "legalhold" },
            { "data": "terminated_date" },
            { "data": "email" },
            { "data": "employee_type" },
            { "data": "no_of_assets" },
        ],
        lengthMenu: [
            [ 50, 100, 200],
            [ '50', '100', '200']
        ],
        columnDefs: [
        { orderable: false, targets: [0, 1, 2, 3, 4, 5, 6, 7, 8, 9] }
        ],
        "aaSorting": [],
        "dom": '<"top"i>rt<"bottom"flp><"clear">',
        "bAutoWidth": false,
        "bFilter": true,
        "bLengthChange": false,
        "searching": false,
        createdRow: function( row, data, dataIndex ) {
            if(data.dataCount > 0) {
                $(row).find('td:eq(0)').addClass('details-control');
                $(row).find('td:eq(7)').addClass('details-control');
                $(row).attr('data-id',data.dataId);
            } 
        },
        fixedHeader: {
            header: true,
        }

    });
    var table2 = $('.dataTable-panel-inactive').DataTable({

        "processing": true,
        "serverSide": true,
        "ajax":{
            "url": "{{ route('employees-inactive-data') }}",
            "dataType": "json",
            "type": "POST",
            "data": {"status" : "inactive"}
        },
        "columns": [
            { "data": "details" },
            { "data": "id" },
            { "data": "first_name" },
            { "data": "last_name" },
            { "data": "hire_date" },
            { "data": "legalhold" },
            { "data": "terminated_date" },
            { "data": "email" },
            { "data": "employee_type" },
            { "data": "no_of_assets" },
        ],
        lengthMenu: [
            [ 50, 100, 200],
            [ '50', '100', '200']
        ],
        columnDefs: [
        { orderable: false, targets: [0, 1, 2, 3, 4, 5, 6, 7, 8, 9] }
        ],
        "aaSorting": [],
        "dom": '<"top"i>rt<"bottom"flp><"clear">',
        "bAutoWidth": false,
        "bFilter": true,
        "bLengthChange": false,
        "searching": false,
        createdRow: function( row, data, dataIndex ) {
            if(data.dataCount > 0) {
                $(row).find('td:eq(0)').addClass('details-control');
                $(row).find('td:eq(7)').addClass('details-control');
                $(row).attr('data-id',data.dataId);
            } 
        },
        fixedHeader: {
            header: true,
        }

    });
       $('.dataTable-panel-active').on('click', 'td.details-control', function (e) {
          e.preventDefault();
        var tr = $(this).closest('tr');

        showAssets(table1, tr);
      });

      $('.dataTable-panel-inactive').on('click', 'td.details-control', function (e) {
          e.preventDefault();
        var tr = $(this).closest('tr');

        showAssets(table2, tr);
      });

    

      function showAssets(table, tr)
      {
          var row = table.row( tr );

          if ( row.child.isShown() ) {
            // This row is already open - close it
            row.child.hide();
            tr.removeClass('shown');
            tr.find('.detail').html('<i class="icon icon-e-add"></i>');
        }
        else {
            // Open this row
            $.ajax({
                type: 'POST',
                data: {id: tr.data('id')},
                url: "/employee-landing/get_assets",
                success: function (assets) {
                    row.child('<table class="footable collaptable table table-stripped table-hover">'+addRows(assets)+'</table>').show();
                }
            });
            tr.addClass('shown');
            tr.find('.detail').html('<i class="icon icon-e-delete"></i>');
        }
      }

    function addRows(assets)
    {
        var rows = addHeader();
        $.each(assets, function (i) {
            rows = rows+'<tr>'+addColumns(assets[i])+'</tr>';
        });

        return rows;
    }

    function addHeader()
    {
        return '<tr>'+
            '<th></th>'+
            '<th>Hardware Standard</th>'+
            '<th>Tech Specs</th>'+
            '<th>Serial #</th>'+
            '<th>Asset Tag #</th>'+
            '<th>Asset Status</th>'+
            '</tr>';
    }

    function addColumns(asset)
    {
        return '<td></td>'+
            '<td>'+asset['make_model_name']+
            '<td>'+asset['details']+
            '<td>'+asset['serial_no']+
            '<td>'+asset['asset_tag']+
            '<td>'+asset['asset_status']+
            '</td>';
    }

    $("#add-asset-row").on('click', function () {
        var assetRow = $("#asset-row").clone();
        assetRow.appendTo("#row-container");

        var count = $('#asset_count').val();
        count++;
        assetRow.find("input[type='text']").val("");
        assetRow.find("input[name='make_and_model1']").attr('name', 'make_and_model'+count);
        assetRow.find("input[name='serial_no1']").attr('name', 'serial_no'+count);
        assetRow.find("input[name='asset_tag1']").attr('name', 'asset_tag'+count);
        $('#asset_count').val(count);
    });
});

$('#disputeFormModal').on('show.bs.modal', function (event) {
  var button = $(event.relatedTarget)
  var assetId = button.data('asset-id')
  var modal = $(this)
  modal.find('#asset_disput_id').val(assetId)
});


</script>