@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'My TeQ Assets'])
<div class="wrapper-content">
    <div class="container-fluid">

       
        @include('partials.success')
        @include('partials.error')

        <div class="row row-equal">
            @forelse($userData['employeeAssets'] as $asset)
            <div class="col col-lg-4 m-b">
                <div class="ibox h-100 m-b-none">
                    <div class="ibox-content">
                        <button type="button" class="btn btn-primary pull-right" data-toggle="modal"
                            data-target="#disputeFormModal" data-asset-id="{{$asset->id}}">DISPUTE</button>
                        <dl class="dl-horizontal">
                            <dt>Hardware Standard</dt>
                            <dd>{{optional($asset->makeAndModel)->makeModelName}}</dd>
                            <dt>Tech Specs</dt>
                            <dd>{{optional($asset->technicalSpec)->details}}</dd>
                            <dt>Serial #</dt>
                            <dd>{{$asset->serial_no}}</dd>
                            <dt>Asset Tag #</dt>
                            <dd>{{$asset->asset_tag}}</dd>
                            <dt>Asset Status</dt>
                            <dd>{{$asset->assetStatus->name}}</dd>
                            @if($asset->assetStatus->slug == "loaned")
                            <dt>Expected Return Date</dt>
                            <dd>
                                <label
                                    class="no-label minimum-width"><span>{{$asset->loaner_return_date}}</span></label>
                                <a class="edit-input" href="#"><i class="icon icon-n-edit" data-toggle="tooltip"
                                        data-placement="right"
                                        title="Modify the Expected Return Date should you decide to keep the device on loan"></i></a>
                                <input type="text" class="loaner-return-date-edit-input form-control">
                                <input type="hidden" value="{{$asset->id}}">
                            </dd>
                            @else
                            <div style="height: 28px;"></div>
                            @endif
                        </dl>
                    </div>
                </div>
            </div>
            @empty
            @endforelse
        </div>

    
        <button type="button" class="btn btn-primary m-b dispute-common-btn"
                    data-toggle="modal" data-target="#disputeCommonModal">I am using a device that is not assigned to me</button>
        

        <div class="row">
            <div class="col-lg-4">
                <div class="ibox">
                    <div class="ibox-title">
                        <h5>My Assets count by Type</h5>
                    </div>
                    <div class="ibox-content">
                        <div id="morris-donut-chart"></div>
                    </div>
                </div>
            </div>
            <div class="col-lg-4">
                <div class="ibox">
                    <div class="ibox-title">
                        <h5>My Assets count by Age</h5>
                    </div>
                    <div class="ibox-content">
                        <div id="morris-donut-chart2"></div>
                    </div>
                </div>
            </div>
        </div>

        @if($userData['isManager'])
        <div class="row">
            <div class="col-lg-12">
                <div class="ibox">
                    <div class="ibox-title">
                        <h3>My Teams Assets</h3>
                    </div>
                    <div class="ibox-content">
                        <div class="row">
                            <div class="col-lg-12">
                                <ul class="nav nav-tabs" role="tablist">
                                    <li role="presentation" class="active"><a href="#active" aria-controls="active"
                                            role="tab" data-toggle="tab">Active</a></li>
                                    <li role="presentation"><a href="#inactive" aria-controls="inactive" role="tab"
                                            data-toggle="tab">Inactive</a></li>
                                </ul>
                                <div class="tab-content">
                                    <div role="tabpanel" class="tab-pane active" id="active">
                                        <div class="ibox-content p-0">
                                            <div class="overflow-auto">
                                                @include('employee.partials.team-assets', ['users' =>
                                                $userData['managerActiveTeam'], 'team' => 'active'])
                                            </div>
                                        </div>
                                        @if(count($userData['managerActiveTeam']) > 0)
                                        <div class="ibox-footer">
                                            <a href="/employee-landing/export_active_team" role="button"
                                                class="btn btn-primary">Export</a>
                                        </div>
                                        @endif
                                    </div>

                                    <div role="tabpanel" class="tab-pane" id="inactive">
                                        <div class="ibox-content p-0">
                                            <div class="overflow-auto">
                                                @include('employee.partials.team-assets', ['users' =>
                                                $userData['managerInActiveTeam'], 'team' => 'inactive'])
                                            </div>
                                        </div>
                                        @if(count($userData['managerInActiveTeam']) > 0)
                                        <div class="ibox-footer">
                                            <a href="/employee-landing/export_in_active_team" role="button"
                                                class="btn btn-primary">Export</a>
                                        </div>
                                        @endif
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        @endif
    </div>
</div>

@include('employee.partials.dispute-modal')
@include('employee.partials.dispute-common-modal')

@stop

@section('help-links')
@include('help.help-links',['helpLink'=>config('help-links.help_links.my_teq_assets'),'helpTitle'=>config('help-links.help_titles.my_teq_assets')])
@endsection

@section('after_scripts')
@include('employee.partials.scripts')

<!-- Morris -->
<script src="js/plugins/morris/raphael-2.1.0.min.js"></script>
<script src="js/plugins/morris/morris.min.js"></script>

<script>

    $(function () {

        Morris.Donut({
            element: 'morris-donut-chart',
            data: {!! json_encode($userData['donutAssetsCountByTypeData'])!!},
        resize: true,
        colors: ['#337ab7', '#f8ac59', '#1ab394', '#ed5565'],
        labelColor:"#828282"
        });

    Morris.Donut({
        element: 'morris-donut-chart2',
        data: {!! json_encode($userData['donutAssetsCountByAgeData'])!!},
    resize: true,
        colors: ['#337ab7', '#f8ac59', '#1ab394'],
        labelColor:"#828282"
        });

    });

</script>

@stop