<script src="/js/plugins/dataTables/datatables.min.js"></script>
<script>
  $(document).ready(function () {
        $(".filter-field-zoom").each(function() {
            var name = $(this).attr('key');
            $( this ).select2({
                minimumInputLength: 1,
                multiple: true,
                ajax: {
                    url: '/discovery-tools/zoom/get-filter-fields',
                    dataType: "json",
                    data: function (params){
                      var query = {
                        search: params.term,
                        type: name
                    }

                      // Query parameters will be ?search=[term]&type=public
                      return query;
                  },
                  processResults: function (data) {
                      // Tranforms the top-level key of the response object from 'items' to 'results'
                      return {
                            results: data
                        };
                    },
                }
            });
        });

        $('#viewIssueModal').on('show.bs.modal', function (e) {
            var id = $(e.relatedTarget).data('zoom-asset-id');
            $.ajax({
                type: "POST",
                url: "/discovery-tools/zoom/get-issue-detail/"+id,
                success: function(value) {
                    $('#comment-body').html(value);
                }
            });
        });

        $('#viewAVModal').on('show.bs.modal', function (e) {
            var id = $(e.relatedTarget).data('zoom-asset-id');
            $.ajax({
                type: "POST",
                url: "/discovery-tools/zoom/get-av-detail/"+id,
                success: function(value) {
                    $('#av-table-body').html(value);
                }
            });
        });
    });
</script>
