@extends('layouts.main')
@section('content')
@include('discovery-tools.zoom.submenu')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'Deployed - Active, Not Managed', 'parentUrl' => '#', 'parentTitle' => 'Discovery Tools'])
<div class="wrapper wrapper-content">
    <div class="container-fluid">
        <div class="row">
            @include('discovery-tools.zoom.partials.devices-not-managed-filter')
        </div>
        <div class="row">
            <div class="col-lg-12">
                <div class="ibox">
                    <div class="ibox-title">
                        <div class="ibox-tools">
                            <a href="#" id="export-csv" class="btn btn-primary">Export to CSV</a>
                        </div>
                    </div>
                    <div class="ibox-content">
                        @include('partials.success')
                        @include('partials.error-message')
                        <div class="ajax-loader"><img src="/img/ajax-loader-full-width.gif"></div>

                        <div class="table-responsive">
                            <table class="footable table table-stripped nowrap" data-page-size="50" data-filter=#filter>

                                <thead>

                                    <tr>

                                        <th>#</th>

                                        <th>Serial #</th>

                                        <th>Asset Status</th>

                                        <th>Location (Teqtivity)</th>

                                        <th>Calendar Name(Zoom)</th>

                                        <th>Location (Zoom)</th>

                                        <th>Health</th>

                                        <th>Network Type</th>

                                        <th>Last Start Time</th>

                                    </tr>

                                </thead>

                                <tbody>

                                </tbody>

                            </table>

                        </div>

                    </div>

                </div>

            </div>

        </div>

    </div>

</div>
@stop

@section('after_scripts')

@include('discovery-tools.zoom.scripts.common-script')
@include('discovery-tools.zoom.scripts.devices-not-managed')

@stop