@extends('layouts.main')
@section('content')
@include('discovery-tools.zoom.submenu')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'All Zoom Devices Report', 'parentUrl' => '#', 'parentTitle' => 'Discovery Tools',  'parentSubUrl' => '#', 'parentSubTitle' => 'Zoom'])
<div class="wrapper wrapper-content">
    <div class="container-fluid">

        <div class="row">
            @include('discovery-tools.zoom.partials.all-report-filter')
		</div>

        <div class="row">
            <div class="col-lg-12">
                <div class="ibox">
                    <div class="ibox-title">
                        <div class="ibox-tools">
                            <a href="#" id="export-csv" class="btn btn-primary" data-url="{{ route('zoom-all-report-export') }}" data-file-name="all-zoom-report">Export to CSV</a>
                        </div>
                    </div>
                    <div class="ibox-content">
                        @include('partials.success')
                        @include('partials.error-message')
                        <div class="ajax-loader"><img src="/img/ajax-loader-full-width.gif"></div>

                        <div class="table-responsive">
                            <table class="table table-stripped nowrap" data-role="ui-data-table" data-url="{{ route('zoom-all-report-data') }}" data-searching="false" data-ordering="false" data-page-size="50">

                                <thead>

                                    <tr>

                                        <th data-col-name="id">#</th>

                                        <th data-col-name="serial">Serial #</th>

                                        <th data-col-name="asset_status">Asset Status</th>

                                        <th data-col-name="location">Location (Teqtivity)</th>

                                        <th data-col-name="room_name_zoom">Room Name (Zoom)</th>

                                        <th data-col-name="site_code_zoom">Site Code (Zoom)</th>

                                        <th data-col-name="region_zoom">Region (Zoom)</th>

                                        <th data-col-name="device_type_zoom">Device Type (Zoom)</th>

                                        <th data-col-name="device_system_zoom">Device System (Zoom)</th>

                                        <th data-col-name="status_zoom">Status (Zoom)</th>

                                        <th data-col-name="host_name_zoom">Host Name (Zoom)</th>

                                        <th data-col-name="manufacturer_zoom">Manufacturer (Zoom)</th>

                                        <th data-col-name="make_and_model_zoom">Make and Model (Zoom)</th>

                                        <th data-col-name="firmware_zoom">Firmware (Zoom)</th>

                                        <th data-col-name="app_version_zoom">App Version (Zoom)</th>

                                        <th data-col-name="ip_address_zoom">IP Address (Zoom)</th>

                                        <th data-col-name="mac_addresses_zoom">MAC Addresses (Zoom)</th>

                                    </tr>

                                </thead>
                            </table>
                        </div>

                    </div>

                </div>

            </div>

        </div>

    </div>

</div>
@include('discovery-tools.zoom.modals.issue-modal')
@include('discovery-tools.zoom.modals.av-modal')
@stop

@section('after_scripts')
@include('reports.scripts.common')
@include('reports.scripts.datatable')
@include('discovery-tools.zoom.scripts.common-script')

@stop
